import sys
import os
import requests
from bs4 import BeautifulSoup


_saved_files = set()
_new_saves = []
_in_subdir = False
_file_in_progress = None
_last_dir = None

# Returns the name of the file
def get_file_name(URL):
	lst = URL.rsplit('/')
	name = lst[-1]
	return name


# Gets the origin url
def get_origin(URL):
	lst = URL.rsplit('/')
	length = len(lst)
	lst = lst[2:(length-1)]
	origin = "https://"
	for x in lst:
		origin += x
	return origin


# Returns list containing all files
def get_links(soup, check_str):
	links = soup.find_all('a')
	unfin_paths = []
	for link in links:
		href = link.get('href')
		if href is None:
			continue
		# Check if link is of data
		for string in check_str:
			if string in href:
				unfin_paths.append(href)
				break
	return unfin_paths


# Uses a link list to return a complete list of files
def get_paths(unfinished_lst, origin):
	finished = []
	for x in unfinished_lst:
		finished.append(origin+x)
	return finished


# Saves a file from the given URL
# TODO fix no download issue on random files
def save_file(URL):
	name = get_file_name(URL)
	n = 1
	while name in os.listdir():
		lst = name.split('.')
		ext = lst[-1]
		lst = lst[:-1]
		lst.append(" ({})".format(n))
		temp_name = "".join(lst) + "." + ext
		if temp_name not in os.listdir():
			name = temp_name
		n += 1
	print("Downloading: {}".format(name))
	
	global _file_in_progress
	_file_in_progress = name
	in_file = requests.get(URL, stream=True)
	out_file = open(name, 'wb')
	for chunk in in_file.iter_content(chunk_size=8192):
		out_file.write(chunk)
	out_file.close()
	#print("Saved: {}".format(name))
	_file_in_progress = None


# Get all links and download them for the "project"
# TODO implement project updating
# TODO filter out thumbnails
def download_and_save_all(URL):
	global _saved_files
	global _new_saves
	
	origin_path = get_origin(URL)
	check_str = ["patreon_data", "patreon_inline"]

	response = requests.get(URL)
	soup = BeautifulSoup(response.content, "html.parser")
	name_element = soup.find_all('span', {"class": "yp-info-name"})[0].string

	# Create folder to save files
	if name_element not in os.listdir():
		os.mkdir(name_element)

	down_directory(name_element)

	links = get_paths(get_links(soup, check_str), origin_path)

	links = [i.replace("partypatreon", "party", 1) for i in links]

	yp = "yiff.party/"
	
	for file_path in links:
		uid = file_path
		idx = file_path.find(yp)
		if idx != -1:
			uid = uid[idx+len(yp):]
		
		if uid not in _saved_files:
			save_file(file_path)
			_new_saves.append(uid)
			_saved_files.add(uid)
		else:
			print("File: {} already saved in archive".format(uid))
	up_directory()

def down_directory(name):
	os.chdir(name)
	global _in_subdir
	global _last_dir
	_in_subdir = True
	_last_dir = name
	
def up_directory():
	global _in_subdir
	if _in_subdir:
		# return back to execution dir
		os.chdir("..")
		_in_subdir = False

def main():
	global _saved_files
	global _new_saves
	global _file_in_progress
	global _last_dir
	
	try:
		if os.path.isfile("_saved_files.txt"):
			with open("_saved_files.txt","r") as f:
				text = f.read()
				_saved_files = {i.strip() for i in text.split("\n")}

		projects = sys.argv[1:]
		for project in projects:
			print("\n==========================================================")
			print("\n*Starting project {}".format(get_file_name(project)))
			download_and_save_all(project)
			print("\n*Project {} done".format(get_file_name(project)))

		print("\n*******************************************************************************\n")
		print("\nAll projects DONE\n")
		print("\nEnjoy ;)")
	except (Exception, KeyboardInterrupt):
		up_directory()
		if _file_in_progress is not None and _last_dir is not None:
			if not _last_dir.endswith("/"):
				_last_dir += "/"
			file_loc = _last_dir+_file_in_progress
			if os.path.isfile(file_loc):
				print("Deleting temporary file: {}".format(file_loc))
				os.remove(file_loc)
			
	
	print("Saving files list")
	with open("_saved_files.txt","a") as f:
		f.write("\n".join(_new_saves)+"\n")
	

if __name__ == "__main__":
	main()
