# coding=utf-8
# Copyright 2021 The rinna, EleutherAI, and HuggingFace Teams. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
""" GPT-Neox model configuration """

from transformers.configuration_utils import PretrainedConfig
from transformers.utils import logging


logger = logging.get_logger(__name__)

GPT_NEOX_PRETRAINED_CONFIG_ARCHIVE_MAP = {}

class GPTNeoXConfig(PretrainedConfig):
    model_type = "gpt_neox"
    attribute_map = {
        "max_position_embeddings": "n_positions",
        "hidden_size": "n_embd",
        "num_attention_heads": "n_head",
        "num_hidden_layers": "n_layer",
    }

    def __init__(
        self,
        vocab_size=50400,
        n_positions=2048,
        n_embd=4096,
        n_layer=28,
        n_head=16,
        rotary_dim=None,
        n_inner=None,
        activation_function="gelu",
        resid_pdrop=0.0,
        embd_pdrop=0.0,
        attn_pdrop=0.0,
        layer_norm_epsilon=1e-5,
        initializer_range=0.02,
        scale_attn_weights=True,
        use_cache=True,
        bos_token_id=0,
        eos_token_id=0,
        split_layernorm=False,
        model_device=None, # one of: None (auto), "cpu", "cuda", "cuda:0" etc.
        model_dtype="fp16", # one of: "fp16", "fp32", "bf16"
        tie_word_embeddings=False,
        lm_head_bias=False,
        gpt_j_residual=False,
        **kwargs
    ):
        self.vocab_size = vocab_size
        self.n_positions = n_positions
        self.n_embd = n_embd
        self.n_layer = n_layer
        self.n_head = n_head
        self.n_inner = n_inner
        self.rotary_dim = rotary_dim
        self.max_position_embeddings = n_positions
        self.hidden_size = n_embd
        self.num_attention_heads = n_head
        self.num_hidden_layers = n_layer
        self.activation_function = activation_function
        self.resid_pdrop = resid_pdrop
        self.embd_pdrop = embd_pdrop
        self.attn_pdrop = attn_pdrop
        self.layer_norm_epsilon = layer_norm_epsilon
        self.initializer_range = initializer_range
        self.scale_attn_weights = scale_attn_weights
        self.split_layernorm = split_layernorm
        self.use_cache = use_cache
        self.model_device = model_device
        self.model_dtype = model_dtype
        self.lm_head_bias = lm_head_bias
        self.gpt_j_residual = gpt_j_residual
        self.tie_word_embeddings = tie_word_embeddings

        self.bos_token_id = bos_token_id
        self.eos_token_id = eos_token_id

        super().__init__(
            bos_token_id=bos_token_id, eos_token_id=eos_token_id, tie_word_embeddings=tie_word_embeddings, **kwargs
        )
