import { StaticImageData } from 'next/image'
import { CommitHash } from '../globals/constants'

// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
export function importAll(r: __WebpackModuleApi.RequireContext) {
    return r.keys().map((element: any) => r(element))
}
export const backgroundImages = importAll(
    // eslint-disable-next-line unicorn/prefer-module
    require.context('../assets/images/landing/backgrounds/', false)
)
export const hashCode = (s: string): number =>
    [...s].reduce((a, b) => {
        a = (a << 5) - a + (b.codePointAt(0) ?? 1)
        return a & a
    }, 0)

let index = Math.abs(hashCode(CommitHash) % backgroundImages.length)
if (index === 30) index++ // egg
export const backgroundIndex = index

export const defaultBackground = backgroundImages[backgroundIndex].default

export const getBackground = (index: number): StaticImageData =>
    backgroundImages[index % backgroundImages.length].default
