/* eslint-disable jsx-a11y/no-static-element-interactions */
/* eslint-disable jsx-a11y/no-noninteractive-element-interactions */
/* eslint-disable jsx-a11y/click-events-have-key-events */
import Head from 'next/head'
import Link from 'next/link'
import { Fragment, MutableRefObject, useCallback, useEffect, useRef, useState } from 'react'
import { useRecoilCallback, useRecoilValue } from 'recoil'
import styled from 'styled-components'
import { BsFullscreen } from 'react-icons/bs'

import { MdOndemandVideo } from 'react-icons/md'
import { toast } from 'react-toastify'
import { LoginLink } from '../..'
import { LoadingSpinner } from '../../../components/loading'
import { Session, SessionValue } from '../../../globals/state'
import { useAutoLogin } from '../../../hooks/useAutoLogin'
import { ArrowLeftIcon, ThumbEmptyIcon, ThumbIcon } from '../../../styles/ui/icons'
import { FlexColSpacer, FlexRow } from '../../../styles/ui/layout'
import { ContestsLayout, InnerContainer, ToLanding } from '../../contest'
import { randomizeArray } from '../../../util/util'
import { SubtleButton } from '../../../styles/ui/button'
import { BackendURLVoteContest } from '../../../globals/constants'
import { logError } from '../../../util/browser'
import Modal, { ModalType } from '../../../components/modals/modal'
import { CloseButton } from '../../../components/modals/common'
import { Dark } from '../../../styles/themes/dark'
import { UserSettings } from '../../../data/user/settings'
import { Confetti } from '../submit/art'
import { subscriptionIsActive } from '../../../util/subscription'
import { DEFAULT_THEME } from '../../../styles/themes/theme'

export default function ContestContent(): JSX.Element {
    const [loaded, setLoaded] = useState(false)
    useAutoLogin(
        () => setLoaded(true),
        () => setLoaded(true)
    )
    const theme = Dark
    return (
        <Fragment>
            <Head>
                <title>A Call For Celebration Contest - NovelAI</title>
            </Head>
            <InnerContainer>
                <FlexColSpacer min={23} max={23} />
                <FlexRow>
                    <Link href="/stories" passHref>
                        <a>
                            <FlexRow grow={false}>
                                <ArrowLeftIcon theme={theme} />
                                <ToLanding>Back to Stories</ToLanding>
                            </FlexRow>
                        </a>
                    </Link>
                    <FlexRow grow={false}>
                        <LoginLink target="_blank" href="https://discord.com/invite/novelai">
                            Discord
                        </LoginLink>
                    </FlexRow>
                </FlexRow>
                <FlexColSpacer min={30} max={30} />
            </InnerContainer>
            <InnerContainer>{loaded ? <VoteContainer /> : <LoadingSpinner visible />}</InnerContainer>
        </Fragment>
    )
}
ContestContent.Layout = ContestsLayout

const VoteWrapper = styled.div`
    margin-top: 50px;
    width: 100%;
    display: flex;
    flex-direction: column;
    align-items: flex-start;
    @media screen and (max-width: 1000px) {
        align-items: center;
    }
`

export function VoteContainer() {
    return (
        <VoteWrapper>
            <h1>Contest Art Submissions</h1>
            <VoteList />
        </VoteWrapper>
    )
}

const VoteGroup = styled.div`
    margin-top: 20px;
    display: flex;
    flex-direction: row;
    justify-content: space-between;
    flex-wrap: wrap;
    gap: 20px;
    @media screen and (max-width: 1000px) {
        align-items: center;
        justify-content: center;
    }
`

interface ArtSubmission {
    author: string
    key: string
    url: string
    socials: string
    medium: string
}

export function VoteList() {
    const [votes, setVotes] = useState([] as string[])
    const loadVotes = useRecoilCallback(({ snapshot }) => async () => {
        try {
            const session = await snapshot.getPromise(Session)
            if (!session?.authenticated) return
            const request = await fetch(BackendURLVoteContest + '/anniversary2022-art', {
                cache: 'no-store',
                headers: {
                    'Content-Type': 'application/json',
                    Authorization: 'Bearer ' + session.auth_token,
                },
                method: 'GET',
            })
            const json = await request.json()
            if (json.statusCode && json.statusCode !== 200) {
                toast(json.message || 'Loading votes failed.')
                return false
            }
            setVotes(json?.map?.call(json, (e: Record<string, any>) => e.submissionId))
            return true
        } catch (error: any) {
            logError(error)
            toast(error.message ?? '' + error)
            return false
        }
    })
    const castVote = useRecoilCallback(({ snapshot }) => async (id: string, up: boolean) => {
        const session = await snapshot.getPromise(Session)
        if (!session.authenticated || !subscriptionIsActive(session.subscription)) {
            toast('Only accounts with an active subscription can cast votes.')
            return false
        }
        try {
            const request = await fetch(BackendURLVoteContest + '/anniversary2022-art', {
                cache: 'no-store',
                headers: {
                    'Content-Type': 'application/json',
                    Authorization: 'Bearer ' + session.auth_token,
                },
                method: up ? 'POST' : 'DELETE',
                body: JSON.stringify({
                    id,
                }),
            })
            if (request.status === 200 || request.status === 201) {
                if (up) setVotes((votes) => [...votes, id])
                else setVotes((votes) => votes.filter((vote) => vote !== id))
                return true
            }
            const json = await request.json()
            if (json.statusCode && (json.statusCode !== 200 || json.statusCode !== 201)) {
                toast(json.message || 'Voting failed.')
                return false
            }
            if (up) setVotes((votes) => [...votes, id])
            else setVotes((votes) => votes.filter((vote) => vote !== id))
            return true
        } catch (error: any) {
            logError(error)
            toast(error.message ?? ('' + error || 'Voting failed.'))
            return false
        }
    })
    useEffect(() => {
        loadVotes()
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [])

    const [art, setArt] = useState([] as ArtSubmission[])
    useEffect(() => {
        ;(async () => {
            const request = await fetch('/anniversaryArt.json')
            const json = await request.json()
            setArt(randomizeArray([...json]))
        })()
    }, [])

    const [expandedArt, setExpandedArt] = useState<ArtSubmission | undefined>()

    const theme = Dark

    return art.length === 0 ? (
        <LoadingSpinner visible />
    ) : (
        <>
            <Modal
                theme={theme}
                style={{ overflow: 'hidden', height: 'unset' }}
                isOpen={expandedArt !== undefined}
                onRequestClose={() => setExpandedArt(void 0)}
                type={ModalType.Large}
                shouldCloseOnOverlayClick={true}
            >
                <VoteExapndedModal>
                    <CloseButton
                        theme={theme}
                        style={{ backgroundColor: '#191b3166', borderRadius: '3px' }}
                        onClick={() => setExpandedArt(void 0)}
                    >
                        <div />
                    </CloseButton>
                    {expandedArt &&
                        (expandedArt?.url.endsWith('mp4') ? (
                            // eslint-disable-next-line jsx-a11y/media-has-caption
                            <video src={expandedArt?.url} controls />
                        ) : (
                            <img src={expandedArt?.url} alt={expandedArt?.author} />
                        ))}
                </VoteExapndedModal>
            </Modal>
            <VoteGroup>
                {art.map((art) => (
                    <VoteImage
                        key={art.key}
                        art={art}
                        setExpandedArt={setExpandedArt}
                        voted={votes.includes(art.key)}
                        onVote={(up: boolean) => castVote(art.key, up)}
                    />
                ))}
            </VoteGroup>
        </>
    )
}

const VoteExapndedModal = styled.div`
    background: #191b31;
    border-radius: 3px;
    border-color: #22253f;
    height: 100%;
    video,
    img {
        max-width: 100%;
        max-height: 100%;
    }
    display: flex;
`

const VoteImageContainer = styled.div`
    background: #191b31;
    display: flex;
    flex-direction: column;
    overflow: visible;
    img {
        background: #0e0f21;
        object-fit: cover;
        width: 280px;
        height: 280px;
        max-width: min(600px, 100vw);
        aspect-ratio: 1/1;
    }
    a {
        transition: all ease-in-out 0.15s;
        cursor: pointer;
        &:hover,
        &:focus {
            transform: scale(1.05);
            box-shadow: 0 0 12px 2px rbga(0, 0, 0, 0.8);
        }
    }
    @media screen and (max-width: 1000px) {
        img {
            width: 100%;
            height: auto;
        }
    }
`
const VideoOverlay = styled.div`
    position: absolute;
    bottom: 10px;
    right: 10px;
    text-shadow: 0 0 10px 0 rgba(0, 0, 0, 0.8);
    text-transform: uppercase;
    display: flex;
    flex-direction: row;
    align-items: center;
    gap: 5px;
    font-size: 1rem;
`

const VoteBar = styled.div`
    height: 40px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-direction: row;
    font-size: 16px;
    > * {
        height: 15px;
        width: 15px;
        margin-left: 10px;
        margin-right: 10px;
        cursor: pointer;
    }
    button {
        transition: all ease-in-out 0.1s;
        &:hover,
        &:focus {
            transform: scale(1.12);
            box-shadow: 0 0 12px 2px rbga(0, 0, 0, 0.8);
        }
    }
`
const Author = styled.div`
    flex: 1;
    line-height: 1rem;
    cursor: default;
`
function VoteImage(props: {
    art: ArtSubmission
    voted: boolean
    onVote: (up: boolean) => Promise<boolean>
    setExpandedArt: (art: ArtSubmission | undefined) => void
}) {
    const loading = useRef(false)
    const vote = useCallback(() => {
        if (loading.current || !props.art.key) return Promise.reject()
        loading.current = true
        return props
            .onVote(!props.voted)
            .finally(() => (loading.current = false))
            .then((r) => r && !props.voted)
    }, [props])

    return (
        <VoteImageContainer>
            <a onClick={() => props.setExpandedArt(props.art)} style={{ position: 'relative', fontSize: 0 }}>
                <img src={props.art.url + '-preview.webp'} alt={props.art.author} />
                {!props.art.url.endsWith('png') && !props.art.url.endsWith('jpg') ? (
                    <VideoOverlay>
                        <MdOndemandVideo /> video
                    </VideoOverlay>
                ) : null}
            </a>
            <VoteBar>
                {/* <VoteButton voted={props.voted} onVote={vote} /> */}
                <Author>{props.art.author}</Author>
                <BsFullscreen onClick={() => props.setExpandedArt(props.art)} />
            </VoteBar>
        </VoteImageContainer>
    )
}

function VoteButton(props: { voted: boolean; onVote: () => Promise<boolean> }) {
    const settings = useRecoilValue(SessionValue('settings')) as UserSettings
    const confettiRef: MutableRefObject<any> = useRef(null)
    const vote = () => {
        props.onVote().then((ok) => {
            if (ok)
                setTimeout(
                    () =>
                        confettiRef.current?.confetti({
                            spread: 38,
                            startVelocity: 14,
                            origin: { y: 0.5 },
                            particleCount: Math.floor(45),
                            colors: [
                                settings.siteTheme?.colors?.textHeadings ?? DEFAULT_THEME.colors.textHeadings,
                            ],
                            scalar: 0.75,
                        }),
                    10
                )
        })
    }
    const theme = Dark
    return (
        <SubtleButton onClick={() => vote()} aria-label={props.voted ? 'Remove Vote' : 'Cast Vote'}>
            <Confetti ref={confettiRef} style={{ bottom: -140 }} />
            {props.voted ? <ThumbIcon theme={theme} /> : <ThumbEmptyIcon theme={theme} />}
        </SubtleButton>
    )
}
