import numpy as np
import time
import os
import json
import math
import torch
from torch import nn
from torch.nn import functional as F
from torch.utils.data import DataLoader

import commons
import utils
from data_utils import TextAudioLoader, TextAudioCollate, TextAudioSpeakerLoader, TextAudioSpeakerCollate
from models import SynthesizerTrn
from text.symbols import symbols
from text import text_to_sequence
import nltk

from scipy.io.wavfile import write

def get_text(text, hps):
    text_norm = text_to_sequence(text, hps.data.text_cleaners)
    if hps.data.add_blank:
        text_norm = commons.intersperse(text_norm, 0)
    text_norm = torch.LongTensor(text_norm)
    return text_norm

hps = utils.get_hparams_from_file("./configs/vctk_base.json")

net_g = SynthesizerTrn(
    len(symbols),
    hps.data.filter_length // 2 + 1,
    hps.train.segment_size // hps.data.hop_length,
    n_speakers=hps.data.n_speakers,
    **hps.model).cuda()
_ = net_g.eval()

_ = utils.load_checkpoint("pretrained_vctk.pth", net_g, None)

line_result = 0
sid = 0
def end_to_end_infer(text, play=True):
    global line_result
    for j in [x for x in text.split("\n") if len(x)]:
        s = time.perf_counter()
        audios = []
        for i in nltk.sent_tokenize(j):
            stn_tst = get_text(i, hps)
            with torch.no_grad(): # save VRAM by not including gradients
                x_tst = stn_tst.cuda().unsqueeze(0)
                x_tst_lengths = torch.LongTensor([stn_tst.size(0)]).cuda()
                sid_t = torch.LongTensor([sid]).cuda()
                audio = net_g.infer(x_tst, x_tst_lengths, sid=sid_t, noise_scale=.667, noise_scale_w=0.8, length_scale=1)[0][0,0].data.detach().float()
                audio *= hps.data.max_wav_value
                audio = audio.cpu().to(torch.int16).numpy()
                audios.append(audio)
        audio = np.concatenate(audios)
        print(f"infer time {time.perf_counter() - s:.02f}")

        wav_fn = f"sid{sid}-{line_result:05}"
        while os.path.exists(wav_fn):
            line_result += 1
            wav_fn = f"sid{sid}-{line_result:05}"
        with open(wav_fn + ".txt", 'w') as fh:
            fh.write(text)
        write(wav_fn + ".wav", 22050, audio)
        line_result += 1
        print("")

if __name__ == "__main__":
    print("enter your text")
    contents = []
    while True:
        try:
            print("-"*50)
            line = input()
            if line[0:3] == "/s ":
                sid = int(line[3:])
                if sid > 108 or sid < 0:
                    sid = 0
                    print("speaker id has to be [0, 108]")
                continue
            if line == "":
                continue
            end_to_end_infer(line)
        except EOFError:
            break
        except KeyboardInterrupt:
            break
