from novelutils.novelfra import *
from pyfra import *
import sys

name = 'kuru-work'
dry = False

config_obj = KubeConfig()
config_obj.set_name(name)
config_obj.set_gpu(gpu_name=GPU.RTX_A6000, amount=1)
config_obj.set_ram(32)
config_obj.set_cpu(4)
config_obj.dry_run(dry)
config_obj.print_information()
config_obj.create_deployment(overwrite=True)
config_obj.create_service()
remote = config_obj.get_pyfra_remote()
env1 = remote.env('noname', python_version=None)
env1.sh('pip install git+https://github.com/finetuneanon/transformers')
env1.sh('pip install /home/xuser/hugessd/pytorch/torch-1.9.1+cu111-cp38-cp38-linux_x86_64.whl')


with always_rerun():
    env1.sh('python3 /home/xuser/hugessd/repos/novelai-training/play.py')