﻿export function hexOpacity(color: string, opacity: number) {
    if (!/^#+([a-f]|[A-F]|\d)+$/.test(color)) {
        console.log('Attempted to apply opacity to an invalid hex string.')
        return '#FFFFFF'
    }
    const opacity256 = (opacity * 255).toFixed()
    const opacityHex = Number(opacity256).toString(16)
    const opacityHexPadded = opacityHex.length < 2 ? '0' + opacityHex : opacityHex
    return color.slice(0, 7) + opacityHexPadded
}
