import { useRecoilCallback } from 'recoil'
import { SettingsPages } from '../../shared/components/settings/constants'
import { ContextReport } from '../../shared/data/ai/context'
import { KeyStore } from '../../shared/data/storage/keystore/keystore'
import { User } from '../../shared/data/user/user'
import { GlobalUserContext } from '../../shared/globals/globals'
import {
    LastContextReport,
    SelectedStory,
    Session,
    SettingsModalOpen,
    Stories,
} from '../../shared/globals/state'
import { removeLocalStorage } from '../util/overrides'

export const useLogout = (): (() => void) => {
    //const router = useRouter() //replace with nav?
    const logout = useRecoilCallback(({ set }) => () => {
        //IndexedDBStorage.teardown() //can't use on mobile
        removeLocalStorage('session')
        set(SettingsModalOpen, SettingsPages.Closed)
        set(SelectedStory, { loaded: false, id: '' })
        set(Stories, [])
        set(LastContextReport, new ContextReport())
        set(Session, new User('', ''))
        GlobalUserContext.keystore = new KeyStore()
        GlobalUserContext.remoteStories = new Set()
        GlobalUserContext.stories = new Map()
        //Sentry.configureScope((scope) => scope.setUser(null))
        //router.push('/') //move to landing?
    })
    return logout
}
