import React from 'react'
import { useRecoilValue } from 'recoil'
import { View } from 'react-native'

import Menubar from './menubar/menubar'
import { AdvancedTab, SlidersTab, StoryTab } from './infobar/infobar'
import TabBar from './navigator/customtabbar'
import { SelectedStoryId, SiteTheme } from '../../shared/globals/state'
import {
    BooksIcon,
    BooksSelectedIcon,
    EditorIcon,
    EditorSelectedIcon,
    GearIcon,
    GearSelectedIcon,
} from '../assets/images/navigation/navicons'
import { AppStateUpdater } from './appstateupdater'
import {
    createMaterialTopTabNavigator,
    MaterialTopTabNavigationProp,
} from '@react-navigation/material-top-tabs'
import { GlobalUserContext } from '../../shared/globals/globals'
import Editor from './editor/panel'

export type StoryAppScreenParams = {
    stories: undefined
    editor: undefined
    options: undefined
    infobar_story: undefined
    infobar_advanced: undefined
    infobar_sliders: undefined
}

export type StoryAppNavigationProp = MaterialTopTabNavigationProp<StoryAppScreenParams>

const Tab = createMaterialTopTabNavigator<StoryAppScreenParams>()

export default function StoryApp(): JSX.Element {
    const siteTheme = useRecoilValue(SiteTheme)
    const selectedStoryId = useRecoilValue(SelectedStoryId)
    const currentStoryContent = GlobalUserContext.storyContentCache.get(selectedStoryId)
    const settings = currentStoryContent?.settings

    return (
        <View style={{ flex: 1, flexDirection: 'column', backgroundColor: siteTheme.colors.bg1 }}>
            <AppStateUpdater />
            <Tab.Navigator
                tabBarPosition={'bottom'}
                initialRouteName={'editor'}
                backBehavior={'initialRoute'}
                keyboardDismissMode={'none'}
                tabBar={(props) => <TabBar {...props} />}
                sceneContainerStyle={{
                    backgroundColor: siteTheme.colors.bg1,
                }}
                screenOptions={{
                    tabBarActiveTintColor: siteTheme.colors.textHeadings,
                    tabBarInactiveTintColor: siteTheme.colors.textMain,
                    tabBarStyle: {
                        backgroundColor: siteTheme.colors.bg1,
                        borderTopColor: siteTheme.colors.bg3,
                        height: 55,
                        borderTopWidth: 1,
                    },
                    tabBarIndicatorStyle: {
                        height: 0,
                    },
                    tabBarScrollEnabled: false,
                    tabBarShowIcon: true,
                    tabBarPressOpacity: 1,
                    tabBarPressColor: 'rgba(0, 0, 0, 0)',
                    tabBarBounces: false,
                    tabBarShowLabel: false,
                    swipeEnabled: true,
                }}
                style={{ position: 'absolute', top: 0, left: 0, height: '100%', width: '100%' }}
            >
                <Tab.Screen
                    name={'stories'}
                    component={Menubar}
                    options={{
                        tabBarIcon: ({ focused }) =>
                            focused ? (
                                <BooksSelectedIcon
                                    primary={siteTheme.colors.textHeadings}
                                    style={{ marginTop: 1, marginLeft: 1 }}
                                />
                            ) : (
                                <BooksIcon primary={siteTheme.colors.textMain} />
                            ),
                        tabBarIconStyle: { paddingTop: 3 },
                    }}
                />
                <Tab.Screen
                    name={'editor'}
                    component={Editor}
                    options={{
                        tabBarIcon: ({ focused }) =>
                            focused ? (
                                <EditorSelectedIcon
                                    primary={siteTheme.colors.textHeadings}
                                    secondary={siteTheme.colors.bg1}
                                />
                            ) : (
                                <EditorIcon primary={siteTheme.colors.textMain} />
                            ),
                        tabBarIconStyle: { paddingTop: 4 },
                    }}
                />
                <Tab.Screen
                    name={'infobar_story'}
                    component={StoryTab}
                    options={{
                        tabBarIcon: ({ focused }) =>
                            focused ? (
                                <GearSelectedIcon primary={siteTheme.colors.textHeadings} />
                            ) : (
                                <GearIcon primary={siteTheme.colors.textMain} />
                            ),
                        tabBarIconStyle: { paddingTop: 3 },
                    }}
                />
                <Tab.Screen name={'infobar_advanced'} component={AdvancedTab} />
                <Tab.Screen name={'infobar_sliders'} component={SlidersTab} />
            </Tab.Navigator>
        </View>
    )
}
