import React from 'react'
import { useRecoilValue } from 'recoil'
import { SiteTheme } from '../../../shared/globals/state'
import AccountSettings from './accountsettings'
import AISettings from './aisettings'
import DefaultsSettings from './defaultssettings'
import InterfaceSettings from './interfacesettings'
import ThemeSettings from './themesettings'
import { createNativeStackNavigator, NativeStackHeaderProps } from '@react-navigation/native-stack'
import { ModalTitleRow } from '../modals/common'

type SettingsScreenParams = { title: string }

type SettingsScreensList = {
    aisettings: SettingsScreenParams
    interface: SettingsScreenParams
    theme: SettingsScreenParams
    account: SettingsScreenParams
    defaults: SettingsScreenParams
}

const SettingsNavigator = createNativeStackNavigator<SettingsScreensList>()

function Header(props: NativeStackHeaderProps): JSX.Element {
    console.log(props.route)
    return (
        <ModalTitleRow
            title={(props.route.params as SettingsScreenParams).title}
            onClose={() => props.navigation.navigate('storyapp')}
        />
    )
}

export default function Settings(): JSX.Element {
    const siteTheme = useRecoilValue(SiteTheme)

    return (
        <SettingsNavigator.Navigator
            screenOptions={{
                presentation: 'modal',
                animation: 'none',
                header: Header,
                contentStyle: {
                    backgroundColor: siteTheme.colors.bg2,
                },
            }}
        >
            <SettingsNavigator.Screen
                name={'aisettings'}
                initialParams={{ title: 'AI Settings' }}
                component={AISettings}
            />
            <SettingsNavigator.Screen
                name={'interface'}
                initialParams={{ title: 'Interface Settings' }}
                component={InterfaceSettings}
            />
            <SettingsNavigator.Screen
                name={'theme'}
                initialParams={{ title: 'Theme Selector' }}
                component={ThemeSettings}
            />
            <SettingsNavigator.Screen
                name={'account'}
                initialParams={{ title: 'Account Settings' }}
                component={AccountSettings}
            />
            <SettingsNavigator.Screen
                name={'defaults'}
                initialParams={{ title: 'Generation Defaults' }}
                component={DefaultsSettings}
            />
        </SettingsNavigator.Navigator>
    )
}
