﻿import React, { useRef } from 'react'
import { MaterialTopTabBar, MaterialTopTabBarProps } from '@react-navigation/material-top-tabs'
import { Animated } from 'react-native'
import { useRecoilState } from 'recoil'
import { InputSelected } from '../../globals/state'
import useIsKeyboardShown from '../../hooks/useKeyboardShown'
import { HoverBar } from '../infobar/infobar'

export default function CustomTabBar(props: MaterialTopTabBarProps): JSX.Element {
    const [inputSelected, setInputSelected] = useRecoilState(InputSelected)
    const keyboardShown = useIsKeyboardShown()
    const slideAnim = useRef(new Animated.Value(1)).current

    //Last ditch effort at consistency with keyboard management.
    React.useEffect(() => {
        setInputSelected(keyboardShown)
    }, [keyboardShown])

    //maybe the animation value can be shared directly across components with recoil, but I'd rather do that later
    React.useEffect(() => {
        !inputSelected
            ? Animated.timing(slideAnim, {
                  toValue: 1,
                  duration: 50,
                  useNativeDriver: true,
              }).start()
            : slideAnim.setValue(0)
    }, [inputSelected])

    return (
        <>
            <HoverBar
                navigationIndex={props.state.index}
                position={props.position}
                navigation={props.navigation}
            />
            <Animated.View
                style={{
                    transform: [
                        {
                            translateY: slideAnim.interpolate({
                                inputRange: [0, 1],
                                outputRange: [30, 0],
                            }),
                        },
                    ],
                    display: !inputSelected ? 'flex' : 'none',
                }}
            >
                <MaterialTopTabBar {...props} />
            </Animated.View>
        </>
    )
}
