﻿import Icon from 'react-native-vector-icons/MaterialIcons'
import styled, { css } from 'styled-components/native'
import { FunnelEmptyIcon, FunnelFilledIcon, HomeIcon, PenWritingIcon } from '../common/icons'
import { BodyMedium600M, BodyLarge400M } from '../../styles/fonts'
import { hexOpacity } from '../../util/colors'

export const Search = styled.View`
    flex: 1;
    justify-content: center;
    padding-horizontal: 20px;
    height: 55px;
`

export const SearchInner = styled.TextInput.attrs((props) => ({
    placeholderTextColor: hexOpacity(props.theme.colors.textMain, 0.5),
}))`
    ${BodyLarge400M};
`

export const IconsRow = styled.View`
    flex-direction: row;
    padding-horizontal: 16px;
`

export const SmallLookingGlass = styled(Icon).attrs(() => ({
    name: 'search',
    size: 25,
}))<{ highlight: boolean }>`
    color: ${(props) => (props.highlight ? props.theme.colors.textHeadings : props.theme.colors.textMain)};
`

const FunnelStyle = css`
    margin-top: 3px;
    margin-right: 10px;
`

export const FunnelEmpty = styled(FunnelEmptyIcon).attrs((props) => ({
    primary: props.theme.colors.textMain,
    width: 20,
    height: 20,
}))`
    ${FunnelStyle}
`

export const FunnelFilled = styled(FunnelFilledIcon).attrs((props) => ({
    primary: props.theme.colors.textHeadings,
    width: 20,
    height: 20,
}))`
    ${FunnelStyle}
`

export const BarView = styled.Pressable<{ darkened: boolean }>`
    background-color: ${(props) => (props.darkened ? props.theme.colors.bg0 : props.theme.colors.bg1)};
    border-color: ${(props) => props.theme.colors.bg3};
    border-top-width: 1px;
    flex-direction: row;
    align-items: center;
    justify-content: space-between;
    width: 100%;
`

export const FilterOptionsView = styled.View`
    padding: 15px 5px 5px;
`

export const DisplayOrder = styled.Pressable`
    flex-direction: row;
    align-items: center;
    padding: 5px 10px 2px;
`

export const ArrowDown = styled(Icon).attrs(() => ({
    name: 'arrow-drop-down',
    size: 30,
}))`
    color: ${(props) => props.theme.colors.textMain};
`

export const ArrowUp = styled(Icon).attrs(() => ({
    name: 'arrow-drop-up',
    size: 30,
}))`
    color: ${(props) => props.theme.colors.textMain};
`

export const OptionContainer = styled.Pressable<{ selected: boolean }>`
    background-color: ${(props) => (props.selected ? props.theme.colors.bg2 : props.theme.colors.bg1)};
    opacity: ${(props) => (props.selected ? '1' : '0.7')};
    justify-content: center;
    min-height: 50px;
`

export const OptionLabel = styled.Text`
    ${BodyMedium600M};
    margin-left: 10px;
`

export const Home = styled(HomeIcon).attrs((props) => ({
    primary: props.theme.colors.textMain,
    height: 20,
    width: 20,
}))`
    margin-top: 4px;
`

export const LeftArrow = styled(Icon).attrs(() => ({
    name: 'chevron-left',
    size: 25,
}))`
    color: ${(props) => props.theme.colors.textMain};
    margin-top: 4px;
`

export const Edit = styled(PenWritingIcon).attrs((props) => ({
    primary: props.theme.colors.textMain,
    height: 20,
    width: 20,
}))`
    margin-right: 10px;
    margin-top: 3px;
`
