﻿import styled from 'styled-components/native'
import { BodyMedium400M } from '../../styles/fonts'
import { hexOpacity } from '../../util/colors'

export const SearchContainer = styled.View``

export const SearchContainerInner = styled.View`
    flex-direction: row;
`

export const LorebookSearch = styled.View`
    background-color: ${(props) => props.theme.colors.bg0};
    flex-grow: 1;
    flex-shrink: 1;
    flex-direction: row;
    padding: 0px 10px;
    align-items: center;
    padding-right: 20px;
`

export const SearchText = styled.TextInput.attrs((props) => ({
    placeholderTextColor: hexOpacity(props.theme.colors.textMain, 0.5),
}))`
    ${BodyMedium400M}
    flex-grow: 1;
    flex-shrink: 1;
    margin-right: 10px;
`

export const LorebookButton = styled.Pressable`
    background-color: ${(props) => props.theme.colors.bg3};
    padding: 16px 18px;
`
