﻿import React from 'react'
import { NativeStackNavigationProp } from '@react-navigation/native-stack'
import { View } from 'react-native'
import { BackgroundSplash, ContentView } from './common.style'
import { RootStackParamList } from '../app'
import { Bar } from './common'

export default function SignUp(props: {
    navigation: NativeStackNavigationProp<RootStackParamList, 'signup'>
}): JSX.Element {
    return (
        <View>
            <BackgroundSplash />
            <ContentView>
                <Bar
                    pushBack={() => props.navigation.navigate('landing')}
                    pushOtherScreen={() => props.navigation.replace('login')}
                    otherScreenName={'Login'}
                />
            </ContentView>
        </View>
    )
}
