import styled from 'styled-components/native'
import { Button } from '../common/button.style'
import ArrowDown from '../../assets/images/directional_arrow_down.svg'
import ArrowUp from '../../assets/images/directional_arrow_up.svg'
import { StoryMode } from '../../../shared/data/story/story'
import { BodyMedium600M, BodyLarge700M, BodyXL600M } from '../../styles/fonts'
import { hexOpacity } from '../../util/colors'
import { PlatformSvgData } from '../../../shared/compatibility/platformtypes'

//Be warned, lots of useless styling in this file, as it was written in less civilized times.

export const ConversationInputContainer = styled.View<{ mode: StoryMode; inputModeIcon: PlatformSvgData }>``

export const ConversationInput = styled.TextInput.attrs((props) => ({
    placeholderTextColor: hexOpacity(props.theme.colors.textMain, 0.5),
}))`
    background: ${(props) => props.theme.colors.bg1};
    min-height: 80px;
    max-height: 80px;
    padding: 10px;
    text-align-vertical: top;
    ${BodyMedium600M};
`
//placeholderTextColor: ${(props) => props.theme.colors.textPlaceholder}

export const ConversationStoryControls = styled.View`
    display: flex;
    flex-direction: row;
    flex-wrap: wrap;
    background: ${(props) => props.theme.colors.bg1};
    font-size: 0.8rpx;
    border-top: 1px solid ${(props) => props.theme.colors.bg3};
    padding: 5px;
`

export const ConversationControlsContent = styled.View<{ visible: boolean; reversed: boolean }>`
    opacity: ${(props) => (props.visible ? 1 : 0)};
    transition: opacity 0.4s ease-in-out, margin-bottom 0.4s ease-in-out;
    background: ${(props) => props.theme.colors.bg2}

    display: flex;
    flex-direction: ${(props) => (props.reversed ? 'column-reverse' : 'column')};
`

export const ConversationControls = styled.View`
    display: flex;
    flex-direction: row;
    align-items: flex-end;
    justify-content: space-between;
    flex-wrap: wrap;
    padding: 7px 0px;
`

export const ConversationControlsGroup = styled.View<{ side: 'left' | 'right' }>`
    display: flex;
    flex-grow: 1;
    flex-direction: row;
    align-items: flex-end;
    justify-content: ${(props) => (props.side === 'right' ? 'flex-end' : 'flex-start')};
    padding: 0px 7px;
    flex-wrap: wrap;
`

export const UndoMenuArrowUpIcon = styled(ArrowUp).attrs((props) => ({
    width: 10,
    height: 10,
    primary: props.theme.colors.textMain,
}))``

export const UndoMenuArrowDownIcon = styled(ArrowDown).attrs((props) => ({
    width: 10,
    height: 10,
    primary: props.theme.colors.textMain,
}))``

export const RequestErrorInfo = styled.Text<{ visible: boolean }>`
    align-items: center;
    color: ${(props) => props.theme.colors.warning};
    display: flex;
    font-size: 1px;
    flex: 1;
`

export const RedoContainer = styled.View`
    flex-direction: row;
    display: flex;
`

export const RedoOption = styled(Button)`
    display: flex;
    flex-direction: row;
    width: 100%;
    font-size: 1px;

    margin: 0;
    overflow: hidden;
    padding: 0;
    min-width: 10%;
    align-items: center;
    display: flex;
    flex-direction: row;
    text-align: start;
`

export const RedoMenu = styled.View`
    background-color: ${(props) => props.theme.colors.bg1};
    max-height: 40vh;
    overflow-y: auto;
    bottom: 100%;
    display: flex;
    flex-direction: column;
    left: 0;
    position: absolute;
    width: 100%;
`

export const ControlText = styled.Text<{ highlight?: boolean }>`
    ${BodyXL600M}
    color: ${(props) => (props.highlight ? props.theme.colors.textHeadings : props.theme.colors.textMain)};
    margin: 0px 5px;
`

export const ControlButton = styled.TouchableOpacity`
    flex-direction: row;
    min-width: 37px;
    padding: 11px 10px 14px;
    margin-left: 2px;
    background-color: ${(props) => props.theme.colors.bg3};
`

export const RedoCounterView = styled.Pressable`
    padding-horizontal: 8px;
    justify-content: center;
    margin-right: 2px;
    background-color: ${(props) => props.theme.colors.bg0};
`

export const RedoCounterText = styled.Text<{ displayToggle: boolean }>`
    ${BodyLarge700M}
    opacity: ${(props) => (props.displayToggle ? '0.7' : '1')};
`
