import React from 'react'
import { Image } from 'react-native'
import styled, { DefaultTheme } from 'styled-components/native'

//OLD
import ArrowDown from '../../assets/images/directional_arrow_down.svg'
import ArrowUp from '../../assets/images/directional_arrow_up.svg'
import PenTip from '../../assets/images/pen-tip-light.svg'
import PenTipHorns from '../../assets/images/pen-tip-horns.svg'
import Book from '../../assets/images/book.svg'
import MagGlass from '../../assets/images/magglass.svg'
import Link from '../../assets/images/link.svg'

//NEW
import FolderIcon from '../../assets/images/icons/folder.svg'
import HeartDisabledIcon from '../../assets/images/icons/heart_disabled.svg'
import HeartEnabledIcon from '../../assets/images/icons/heart_enabled.svg'
import TrashIcon from '../../assets/images/icons/trash.svg'
import LargeTrashIcon from '../../assets/images/icons/large-trash.svg'
import CopyIcon from '../../assets/images/icons/copy.svg'
import ExportIcon from '../../assets/images/icons/export.svg'
import PenWritingIcon from '../../assets/images/icons/penwriting.svg'
import MinusIcon from '../../assets/images/icons/minus.svg'
import PlusIcon from '../../assets/images/icons/plus.svg'
import CrossIcon from '../../assets/images/icons/cross.svg'
import LibraryIcon from '../../assets/images/icons/library.svg'
import FunnelEmptyIcon from '../../assets/images/icons/funnelEmpty.svg'
import FunnelFilledIcon from '../../assets/images/icons/funnelFilled.svg'
import HomeIcon from '../../assets/images/icons/home.svg'
import InkIcon from '../../assets/images/icons/ink.svg'
import StatsIcon from '../../assets/images/icons/stats.svg'
import ClipBoardIcon from '../../assets/images/icons/clipboard.svg'

import ScissorsIcon from '../../assets/images/icons/scissors.svg'
import FlattenIcon from '../../assets/images/icons/flatten.svg'
import DotResetIcon from '../../assets/images/icons/dot-reset.svg'

import { SvgProps } from 'react-native-svg'
import { ThemedStyledProps } from 'styled-components'

//OLD. All of this stuff might go.
export type SvgImageProps = SvgProps & {
    primary?: string | undefined
    secondary?: string | undefined
}

export type SvgImageData = React.FC<SvgImageProps>

export const iconDefaults = {
    width: 20,
    height: 20,
}

export const iconDefaultAttrs = (
    props: ThemedStyledProps<
        SvgImageProps & {
            children?: React.ReactNode
        },
        DefaultTheme
    >
) => ({ ...iconDefaults, primary: props.theme.colors.textMain })

//This one is dumb, but works
const ApplyDefaults = (icon: SvgImageData) =>
    styled(icon).attrs((props) => ({
        primary: props.theme.colors.textMain,
        ...iconDefaults,
    }))``

//revise, need to import
export function OldNaiIcon() {
    return <Image style={iconDefaults} source={require('../../assets/images/novelnai.png')} />
}

export const PenTipIcon = styled(PenTip).attrs(() => ({
    height: 28,
    width: 22,
}))``

export const PenTipHornsIcon = styled(PenTipHorns).attrs(iconDefaultAttrs)``
export const ArrowDownIcon = styled(ArrowDown).attrs(iconDefaultAttrs)``
export const ArrowUpIcon = styled(ArrowUp).attrs(iconDefaultAttrs)``
export const BookIcon = styled(Book).attrs(iconDefaultAttrs)``
export const MagGlassIcon = styled(MagGlass).attrs(iconDefaultAttrs)``

//needs to be changed, xml can no longer be used iirc
export const LinkIcon = styled(Link).attrs(() => ({
    xml: Link,
    height: 12,
    width: 12,
}))``

//NEW
export {
    FolderIcon,
    HeartDisabledIcon,
    HeartEnabledIcon,
    TrashIcon,
    LargeTrashIcon,
    CopyIcon,
    ExportIcon,
    PenWritingIcon,
    MinusIcon,
    PlusIcon,
    CrossIcon,
    LibraryIcon,
    FunnelEmptyIcon,
    FunnelFilledIcon,
    HomeIcon,
    InkIcon,
    StatsIcon,
    ScissorsIcon,
    FlattenIcon,
    DotResetIcon,
    ClipBoardIcon,
}
