# Paint New Image

## Canvas / Paint New Image / Edit Image

Not only can you upload images, but you can also draw an image and subject for the AI to generate (or customize it, but let's cover creating one from scratch first!)

![From sketch & prompt to generation & a quick switch to open eyes!](../assets/drawsmall.gif)

Select the Paint New Image button above your prompt bar. This opens our Canvas and removes the need for you to use external painting software (You always have the option to upload images created in external sources though!).

**There are a few handy tools that you can use while editing in the Canvas:**

- [Draw: The Pen Tool](#draw)
- [Erase: The Erase Tool](#erase)
- [Select: The Select Tool](#select-tool)
- [Color Picker: The Color Picker](#color-picker)
- [The Color Palette](#color-palette)
- [Pen Size](#pen-size)
- [Undo & Redo](#undo--redo)
- [Save File](#save-file)
- [Confirm](#confirm)
- [Cancel](#cancel)

## Draw ![The Pen Tool](../assets/pen.svg)

With Draw you can create your drawn guide for the AI directly on your canvas, on top of an uploaded image or previous image generation. *If you don't like the size of the Pen tool you can adjust it with the Pen Size slider located on the right.*

![The Pen Tool in action!](../assets/pen%20tool.gif)

## Erase ![The Erase Tool](../assets/eraser.svg)

With Erase you can remove anything from your drawn guide. *If you don't like the size of the Erase tool you can adjust it with the Pen Size slider located on the right.*

## Select Tool ![The Select Tool](../assets/select.svg)

Select allows you to freely draw a rectangle you can move around anywhere on your canvas.

![The Select Tool in action!](../assets/select%20tool.gif)

## Color Picker ![The Color Picker](../assets/dropper.svg)

Pick a color from anywhere on your picture. This allows you to swiftly grab a color from any area of your image removing the need to guess the right value on the Color Palette.

## Color Palette ![The Color Palette](../assets/select.svg)

Select a color of your choice by clicking anywhere on the color palette.

## Pen Size

Adjust the size of your Pen by editing the Pen Size slider or clicking the size number and entering a number value of your choice.

## Resize Canvas

Adjust your Canvas size quickly by changing the Size values or use the Shift Edges fields to manually expand or subtract values.

## Undo & Redo

The Canvas records every modification to your Canvas image, so you can always Undo & Redo your changes if you wish to do so.

## Save File

Export the current Canvas file. You can download your newly drawn or edited canvas at any time by using the **Save File** button. Keep in mind that Image Generation is **session based** and all data is lost upon exiting or reloading, so backing up a canvas file allows you to use your Canvas image as a file for the **Upload Image** option in the future.

## Confirm

Confirm all changes to the canvas and return to the Image Generation menu. This will close the Canvas and automatically use the current image for your next Image Generation - you can confirm this by the Thumbnail view next to your Prompt Input bar.

![The confirmed updated Canvas Thumbnail is visible next to the prompt field.](../assets/canvasthumbnailconfirm.png)

## Cancel

Cancel all changes to the canvas and return to the Image Generation menu. This will discard all changes made and return you to the Image Generation menu.

**Tips for generating off a Canvas drawn image:**

- Play around with the Strength & Noise of your next generation:
If you use large sections with only one color you need to up the Noise setting accordingly to provide the AI with some working ground to come up with texture details. 

- Don't want to change much?
Lower both Strength and Noise down to zero, this should keep the image unaffected, this should regenerate your image unaffected. Now you may use Enhance or play around with other settings.


- Consider your text prompt:
It is crucial you consider the text you write alongside the next generation. We've seen very good results if you accurately describe your image alongside what transformation you plan to give it. 

If you want the AI to consider the text input more then try to up the Scale as well as the Strength sliders accordingly. Test different slider strengths at lower steps to get a good preview for what the AI is doing with your work and chosen settings - sometimes as little as 10~15 steps can give a good preview and sense for what you are attempting.
