# Image Generation

![Image Generation has arrived at NovelAI!](../assets/imgisoutnow.png)

## What's image generation?

The NovelAI Diffusion Anime image generation experience is unique and tailored to give you a creative tool to visualize your visions without limitations, allowing you to paint the stories of your imagination. 

Use tags to define the visual characteristics of your character or composition (or you can let AI interpret your words if you prefer!)

NovelAI Diffusion is a tool designed for visual storytelling without any limitations.

Image Generation on NovelAI with our own custom NovelAI Diffusion Models, based on Stable Diffusion:

**NovelAI Diffusion Anime (Curated)**
Good baseline quality and predictable subject matter.

**NovelAI Diffusion Anime (Full)**
The expanded training set allows for a wider variety of generations.

**NovelAI Diffusion Furry (Beta)**
Beta model to easily create Furry and Anthropomorphic Animal themed content. 
This model is not a complete work, and will be expanded upon!


# How it works:

Stable Diffusion works by generating an image based on your text prompt, starting with only noise, and gradually enhancing the image until there is no noise left at all.

![How the AI creates an image by using diffusion](../assets/sdexample.gif)

The AI connects your text to images, generating a new composition every single time you prompt it. 

The NovelAI Diffusion image generation experience is unique, tailored to give you a creative tool to visualize your visions without limitations, allowing you to paint the stories of your imagination. Easily define characteristics of your character and composition with tags and get a little closer to that vision in your head (or not, but now it’s completely up to your choice!) 

![The AI will suggest tags that it knows!](../assets/prompttags.gif)




## Settings at a glance:

![All NovelAI Image Generation Settings at a glance (Subject to change!)](../assets/AllImggenSettings.png)

**Image Resolution**
You can generate Images at a variety of aspect ratios and sizes. Use the dropdown to select the option best suited to your vision!

**Goose Tip:** Press the X between the resolution numbers to quicky swap height and width .

## Normal Generations

**Steps** define the number of iterations the AI should refine for.

**Scale** indicates the AI's prompt interpretation. 
At high Scale, the AI follows your prompt closely, with finer detail and sharpness. Lower Scale give the AI more creative freedom.

![Steps & Scale](../assets/stepsnscale.png)


## Upload Image - Img2Img Generation - Paint New Image - Edit Image - Canvas Generations

**Strength** allows the AI to change the image composition. Lower Strength will generate closer to the original. 

**Noise** may allow the AI to generate more details but can cause strange artifacts if too high.

**Note:** **Strength & Noise** only apply when an image is used to generate with, so these settings **do not appear in the menu unless that condition is met**! 


## Topics to browse
  - [Basics](./image/basics.md)
  - [Tagging](./image/tags.md)
  - [Stengthening & Weakening Vectors](./strengthening-weakening.md)
  - [Image Generation Model](./image/models.md)
  - [Upload Image - Img2Img Generation](./image/uploadimage.md)
  - [Paint New Image - Edit Image - Canvas](./image/editimagecanvas.md)
  - [Steps & Scale](./image/stepsscale.md)
  - [Strength & Noise](./image/strengthnoise.md)
  - [Undesired Content](./image/undesiredcontent.md)
  - [Seed](./image/seed.md)
  - [Enhance](./image/enhance.md)
  - [Advanced: Prompt Mixing](./image/promptmixing.md)
   - [Advanced: Sampling](./image/sampling.md)
  - [Advanced: UI Functionalities](./image/uifunctionalities.md)
  - [FAQ](./image/faq.md)