import { nanoid } from "nanoid";
import {
  BeforeInsert,
  BeforeUpdate,
  Column,
  Entity,
  JoinColumn,
  ManyToOne,
  PrimaryColumn,
  Unique,
} from "typeorm";
import { User } from "./user.entity";

@Entity("user_submission")
@Unique("submission", ["authorEmail", "event"])
export class UserSubmission {
  @PrimaryColumn()
  id: string;

  @Column({ type: "timestamp", default: () => "CURRENT_TIMESTAMP" })
  lastUpdatedAt: Date;

  @Column({
    type: "bytea",
    nullable: true,
  })
  data: Buffer;

  @Column({ default: "", length: 256 })
  dataKey: string;

  @Column({ default: "", length: 256 })
  dataName: string;

  @Column({ default: "", length: 256 })
  authorName: string;

  @Column({ default: "", length: 256 })
  authorEmail: string;

  @Column({ default: "", length: 256 })
  event: string;

  @Column({ default: "", length: 4096 })
  socials: string;

  @Column({ default: "", length: 4096 })
  mediums: string;

  @BeforeInsert()
  generateID() {
    this.id = nanoid();
  }

  @BeforeUpdate()
  updateTimestamp() {
    this.lastUpdatedAt = new Date();
  }

  @ManyToOne(() => User, { onDelete: "CASCADE" })
  @JoinColumn()
  owner: User | null;
}
