import { nanoid } from "nanoid";
import {
  BeforeInsert,
  BeforeUpdate,
  Column,
  Entity,
  JoinColumn,
  ManyToOne,
  PrimaryColumn,
  Index,
} from "typeorm";
import { User } from "./user.entity";

@Entity("userdata")
export class UserData {
  @PrimaryColumn()
  id: string;

  @Column({ default: "unknown", length: 16 })
  @Index()
  type: string;

  @Column({ type: "timestamp", default: () => "CURRENT_TIMESTAMP" })
  lastUpdatedAt: Date;

  @BeforeInsert()
  generateID() {
    this.id = nanoid();
  }

  @BeforeUpdate()
  updateTimestamp() {
    this.lastUpdatedAt = new Date();
  }

  @Column({ default: "", length: 128 })
  meta: string;

  @Column({
    type: "bytea",
    nullable: false,
  })
  data: Buffer;

  @Column({ default: 1 })
  changeIndex: number;

  @ManyToOne(() => User, { onDelete: "CASCADE" })
  @Index()
  @JoinColumn()
  owner: User;

  @Column({ nullable: true })
  ownerId: string;
}
