import {
  Column,
  CreateDateColumn,
  Entity,
  JoinColumn,
  ManyToOne,
  OneToOne,
  PrimaryColumn,
} from "typeorm";
import { User } from "../user.entity";
import { GiftKeySubscriptionData } from "./gift-key.payment-processor";
import { PaddleSubscriptionData } from "./paddle.payment-processor";
import { PaymentProcessors } from "./payment-processors";

@Entity("subscription")
export class SubscriptionData {
  @PrimaryColumn()
  id: string;

  @CreateDateColumn()
  createdAt: Date;

  @Column({ default: 0 })
  paymentProcessor: PaymentProcessors;

  @Column({ type: "jsonb" })
  data: PaddleSubscriptionData | GiftKeySubscriptionData;

  @OneToOne(() => User, (user) => user.subscriptionData, {
    onDelete: "CASCADE",
  })
  @JoinColumn()
  owner: User;

  @ManyToOne(() => User, {
    onDelete: "SET NULL",
  })
  // @JoinColumn()
  referrer: User;
}
