import { ApiProperty } from "@nestjs/swagger";
import { IsIn, IsNotEmpty, IsString } from "class-validator";

export class BindSubscriptionRequest {
  @IsString()
  @IsIn(["paddle", "giftkey", "trial"])
  @ApiProperty({
    description: "Subscription payment processor",
  })
  paymentProcessor: string;

  @IsString()
  @IsNotEmpty()
  @ApiProperty({
    description: "Payment processor ID",
  })
  subscriptionId: string;
}
