import { ApiProperty } from "@nestjs/swagger";
import {
  IsBase64,
  IsNotEmpty,
  IsOptional,
  IsString,
  MaxLength,
} from "class-validator";

export class UserSubmissionInput {
  @IsString()
  @IsNotEmpty()
  @IsBase64()
  @ApiProperty({
    description: "Base64-encoded buffer",
  })
  data: string;

  @IsString()
  @IsNotEmpty()
  @MaxLength(256)
  dataName: string;

  @IsString()
  @IsNotEmpty()
  @MaxLength(256)
  authorName: string;

  @IsString()
  @IsNotEmpty()
  @MaxLength(256)
  authorEmail: string;

  @IsString()
  @IsOptional()
  @MaxLength(4096)
  socials: string;

  @IsString()
  @IsOptional()
  @MaxLength(4096)
  mediums: string;

  @IsString()
  @IsOptional()
  @MaxLength(256)
  event: string;
}
