import { ApiProperty } from "@nestjs/swagger";
import {
  IsBase64,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  MaxLength,
} from "class-validator";

export class UserDataInput {
  @IsString()
  @MaxLength(128)
  @ApiProperty({
    description: "Accompanying non confidential information",
  })
  meta: string;

  @IsString()
  @IsNotEmpty()
  @IsBase64()
  @ApiProperty({
    description: "Base64-encoded buffer",
  })
  data: string;

  @IsOptional()
  @IsNumber()
  @ApiProperty({
    description: "Current change index",
  })
  changeIndex?: number;
}
