import { ApiProperty } from "@nestjs/swagger";
import {
  IsBoolean,
  IsEmail,
  IsNotEmpty,
  IsString,
  MaxLength,
  MinLength,
} from "class-validator";

export class RecoveryStartRequest {
  @IsString()
  @IsNotEmpty()
  @IsEmail()
  @ApiProperty({
    description: "Target email for account recovery",
  })
  email: string;
}

export class RecoveryFinishRequest {
  @IsString()
  @MinLength(16)
  @ApiProperty({
    description: "Recovery token provided in the email letter",
  })
  recoveryToken: string;

  @IsString()
  @IsNotEmpty()
  @MinLength(64)
  @MaxLength(64)
  @ApiProperty({
    description: "New access key",
  })
  newAccessKey: string;

  @IsBoolean()
  @ApiProperty({
    description:
      "Should the server reset keystore and remove objects of stories and storycontent type?",
    default: false,
  })
  deleteContent: boolean;
}
