import { ApiProperty } from "@nestjs/swagger";
import { IsNotEmpty, IsString, MaxLength, MinLength } from "class-validator";

export class LoginRequest {
  @IsString()
  @IsNotEmpty()
  @MinLength(64)
  @MaxLength(64)
  @ApiProperty({
    description: "Required access key",
  })
  key: string;
}
