import { ApiProperty } from "@nestjs/swagger";
import {
  IsAlphanumeric,
  IsEmail,
  IsNotEmpty,
  IsOptional,
  IsString,
  MaxLength,
  MinLength,
} from "class-validator";

export class CreateUserRequest {
  @IsString()
  @IsNotEmpty()
  @ApiProperty({
    description: "ReCAPTCHA response token for the novelai.net domain",
  })
  recaptcha: string;

  @IsString()
  @IsNotEmpty()
  @MinLength(64)
  @ApiProperty({
    description: "Required access key",
  })
  key: string;

  @IsOptional()
  @IsString()
  @IsAlphanumeric()
  @MinLength(64)
  @MaxLength(64)
  @ApiProperty({
    description: "SHA-256 hashed email in hexadecimal",
    required: false,
  })
  email?: string;

  @IsOptional()
  @IsString()
  @IsEmail()
  @ApiProperty({
    description:
      "Email address (provided as cleartext for email verification, stored hashed)",
    required: false,
  })
  emailCleartext?: string;

  @IsOptional()
  @IsString()
  @ApiProperty({
    description:
      "Subscription gift key, if provided will be automatically activated upon registration",
  })
  giftkey?: string;
}
