import { Injectable } from "@nestjs/common";
import { JwtService } from "@nestjs/jwt";
import { User } from "./user.entity";

@Injectable()
export class AuthService {
  constructor(private readonly jwtService: JwtService) {}

  generateTokenForUser(user: User): Promise<string> {
    return this.jwtService.signAsync({
      id: user.id,
      nc: user.authenticationNonce,
    });
  }

  async userIdByJWT(
    jwt: string,
    ignoreExpiration = false,
  ): Promise<{ id: string; nonce: string } | null> {
    try {
      const data = await this.jwtService.verifyAsync(jwt, { ignoreExpiration });
      if (!data || !data.id || !data.nc) return null;

      return {
        id: data.id,
        nonce: data.nc,
      };
    } catch {
      return null;
    }
  }
}
