export enum SubscriptionTiers {
  NONE = 0,
  TABLET = 1,
  SCROLL = 2,
  OPUS = 3,
  // CODEX = 4,
}

export const SubscriptionList = [
  SubscriptionTiers.NONE,
  SubscriptionTiers.TABLET,
  SubscriptionTiers.SCROLL,
  SubscriptionTiers.OPUS,
  // SubscriptionTiers.CODEX,
];

export const MAX_TIER = SubscriptionTiers.OPUS;

export function isTierABetterThanB(
  tierA: SubscriptionTiers,
  tierB: SubscriptionTiers,
): boolean {
  const tierAidx = SubscriptionList.indexOf(tierA);
  if (tierAidx === -1)
    throw new Error(`Failed to find tier ${tierA} in the subscription list.`);
  const tierBidx = SubscriptionList.indexOf(tierB);
  if (tierBidx === -1)
    throw new Error(`Failed to find tier ${tierB} in the subscription list.`);

  return tierAidx > tierBidx;
}

export type ImageGnerationLimit = {
  resolution: number;
  maxPrompts: number;
};

export interface SubscriptionTierPerks {
  maxPriorityActions: number;
  startPriority: number;
  contextTokens: number;
  unlimitedMaxPriority: boolean;
  moduleTrainingSteps: number;
  voiceGeneration: boolean;
  imageGeneration: boolean;
  unlimitedImageGeneration: boolean;
  unlimitedImageGenerationLimits: ImageGnerationLimit[];
}

export const SubscriptionTierData: {
  [key in SubscriptionTiers]: SubscriptionTierPerks;
} = {
  [SubscriptionTiers.NONE]: {
    maxPriorityActions: 0,
    startPriority: 0,
    contextTokens: 0,
    moduleTrainingSteps: 0,
    unlimitedMaxPriority: false,
    voiceGeneration: false,
    imageGeneration: false,
    unlimitedImageGeneration: false,
    unlimitedImageGenerationLimits: [],
  },
  [SubscriptionTiers.TABLET]: {
    maxPriorityActions: 1000,
    startPriority: 10,
    contextTokens: 1024,
    moduleTrainingSteps: 1000,
    unlimitedMaxPriority: false,
    voiceGeneration: true,
    imageGeneration: true,
    unlimitedImageGeneration: false,
    unlimitedImageGenerationLimits: [],
  },
  [SubscriptionTiers.SCROLL]: {
    maxPriorityActions: 1000,
    startPriority: 10,
    contextTokens: 2048,
    moduleTrainingSteps: 1000,
    unlimitedMaxPriority: false,
    voiceGeneration: true,
    imageGeneration: true,
    unlimitedImageGeneration: false,
    unlimitedImageGenerationLimits: [],
  },
  [SubscriptionTiers.OPUS]: {
    maxPriorityActions: 1000,
    startPriority: 10,
    contextTokens: 2048,
    moduleTrainingSteps: 10000,
    unlimitedMaxPriority: true,
    voiceGeneration: true,
    imageGeneration: true,
    unlimitedImageGeneration: true,
    unlimitedImageGenerationLimits: [
      { resolution: 2048 * 2048, maxPrompts: 0 },
      { resolution: 640 * 640, maxPrompts: 1 },
    ],
  },
  /*[SubscriptionTiers.CODEX]: {
    maxPriorityActions: 1000,
    startPriority: 10,
    contextTokens: 2048,
    moduleTrainingSteps: 10000,
    unlimitedMaxPriority: true,
    voiceGeneration: true,
    imageGeneration: true,
    unlimitedImageGeneration: true,
    unlimitedImageGenerationLimits: [
      { resolution: 1024 * 1024, maxPrompts: 1 },
      { resolution: 1024 * 512, maxPrompts: 2 },
      { resolution: 512 * 512, maxPrompts: 4 },
    ],
  },*/
};
