import { MigrationInterface, QueryRunner } from "typeorm";

export class AddUserDataIndexes1660560499061 implements MigrationInterface {
  name = "AddUserDataIndexes1660560499061";

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `CREATE INDEX "IDX_1f6923c97e23ce08d12eda7513" ON "userdata" ("type") `,
    );
    await queryRunner.query(
      `CREATE INDEX "IDX_bf5a183f6cd897f24cd5634580" ON "userdata" ("ownerId") `,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `DROP INDEX "public"."IDX_bf5a183f6cd897f24cd5634580"`,
    );
    await queryRunner.query(
      `DROP INDEX "public"."IDX_1f6923c97e23ce08d12eda7513"`,
    );
  }
}
