import {MigrationInterface, QueryRunner} from "typeorm";

export class KeeoModuleTrainingHistory1660259291810 implements MigrationInterface {
    name = 'KeeoModuleTrainingHistory1660259291810'

    public async up(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE "ai_training_module" ADD "deleted" boolean NOT NULL DEFAULT false`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "emailVerificationLastSentAt" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "deletionSessionUntil" SET DEFAULT to_timestamp(0)`);
    }

    public async down(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "deletionSessionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "emailVerificationLastSentAt" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "ai_training_module" DROP COLUMN "deleted"`);
    }

}
