import {MigrationInterface, QueryRunner} from "typeorm";

export class UpdateContestVotes1654827175488 implements MigrationInterface {
    name = 'UpdateContestVotes1654827175488'

    public async up(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE "user_submission_vote" ADD "event" character varying(256) NOT NULL DEFAULT ''`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "emailVerificationLastSentAt" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "deletionSessionUntil" SET DEFAULT to_timestamp(0)`);
    }

    public async down(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "deletionSessionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "emailVerificationLastSentAt" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user_submission_vote" DROP COLUMN "event"`);
    }

}
