import {MigrationInterface, QueryRunner} from "typeorm";

export class AddUserDeleteToken1649295879073 implements MigrationInterface {
    name = 'AddUserDeleteToken1649295879073'

    public async up(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE "user" ADD "deletionToken" character varying`);
        await queryRunner.query(`ALTER TABLE "user" ADD "deletionSessionUntil" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "emailVerificationLastSentAt" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "ai_training_module" ALTER COLUMN "lastUpdatedAt" SET DEFAULT now()`);
        await queryRunner.query(`ALTER TABLE "userdata" ALTER COLUMN "lastUpdatedAt" SET DEFAULT now()`);
        await queryRunner.query(`ALTER TABLE "user_submission_vote" ALTER COLUMN "lastUpdatedAt" SET DEFAULT now()`);
        await queryRunner.query(`ALTER TABLE "user_submission" ALTER COLUMN "lastUpdatedAt" SET DEFAULT now()`);
        await queryRunner.query(`ALTER TABLE "token_metrics" ALTER COLUMN "flushDate" SET DEFAULT now()`);
    }

    public async down(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE "token_metrics" ALTER COLUMN "flushDate" SET DEFAULT CURRENT_TIMESTAMP`);
        await queryRunner.query(`ALTER TABLE "user_submission" ALTER COLUMN "lastUpdatedAt" SET DEFAULT CURRENT_TIMESTAMP`);
        await queryRunner.query(`ALTER TABLE "user_submission_vote" ALTER COLUMN "lastUpdatedAt" SET DEFAULT CURRENT_TIMESTAMP`);
        await queryRunner.query(`ALTER TABLE "userdata" ALTER COLUMN "lastUpdatedAt" SET DEFAULT CURRENT_TIMESTAMP`);
        await queryRunner.query(`ALTER TABLE "ai_training_module" ALTER COLUMN "lastUpdatedAt" SET DEFAULT CURRENT_TIMESTAMP`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "emailVerificationLastSentAt" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" DROP COLUMN "deletionSessionUntil"`);
        await queryRunner.query(`ALTER TABLE "user" DROP COLUMN "deletionToken"`);
    }

}
