import { MigrationInterface, QueryRunner } from "typeorm";

export class AddUserKeystoreChangeIndex1633631758852
  implements MigrationInterface {
  name = "AddUserKeystoreChangeIndex1633631758852";

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "user" ADD "keystoreChangeIndex" integer NOT NULL DEFAULT '1'`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp(0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp(0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp(0)`,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp((0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp((0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp((0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" DROP COLUMN "keystoreChangeIndex"`,
    );
  }
}
