import { MigrationInterface, QueryRunner } from "typeorm";

export class UserDataMeta1623055250057 implements MigrationInterface {
  name = "UserDataMeta1623055250057";

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "userdata" ADD "meta" character varying(32) NOT NULL DEFAULT ''`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "authenticationNonce" SET NOT NULL`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "authenticationNonce" DROP DEFAULT`,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "authenticationNonce" SET DEFAULT ''`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "authenticationNonce" DROP NOT NULL`,
    );
    await queryRunner.query(`ALTER TABLE "userdata" DROP COLUMN "meta"`);
  }
}
