import { MigrationInterface, QueryRunner } from "typeorm";

export class InitialMigration1622984149738 implements MigrationInterface {
  name = "InitialMigration1622984149738";

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `CREATE TABLE "userdata" ("id" character varying NOT NULL, "type" character varying(16) NOT NULL DEFAULT 'unknown', "lastUpdatedAt" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, "data" bytea NOT NULL, "ownerId" character varying, CONSTRAINT "PK_00dc06b9c7ffd5bdac6dedbf7a1" PRIMARY KEY ("id"))`,
    );
    await queryRunner.query(
      `CREATE TABLE "subscription" ("id" character varying NOT NULL, "paymentProcessor" integer NOT NULL DEFAULT '0', "data" jsonb NOT NULL, "ownerId" character varying, CONSTRAINT "REL_567ea867f45fdcb0423f10849b" UNIQUE ("ownerId"), CONSTRAINT "PK_8c3e00ebd02103caa1174cd5d9d" PRIMARY KEY ("id"))`,
    );
    await queryRunner.query(
      `CREATE TABLE "user" ("id" character varying NOT NULL, "accessKey" character varying NOT NULL, "maxPriorityActions" integer NOT NULL DEFAULT '0', "nextRefillAt" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT to_timestamp(0), "taskPriority" double precision NOT NULL DEFAULT '0', "subscriptionTier" integer NOT NULL DEFAULT '0', "subscriptionUntil" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT to_timestamp(0), "keystore" bytea, "clientSettings" character varying, "subscriptionDataId" character varying, CONSTRAINT "REL_2b74e105b66d5b127356f86ea9" UNIQUE ("subscriptionDataId"), CONSTRAINT "PK_cace4a159ff9f2512dd42373760" PRIMARY KEY ("id"))`,
    );
    await queryRunner.query(
      `ALTER TABLE "userdata" ADD CONSTRAINT "FK_bf5a183f6cd897f24cd56345801" FOREIGN KEY ("ownerId") REFERENCES "user"("id") ON DELETE CASCADE ON UPDATE NO ACTION`,
    );
    await queryRunner.query(
      `ALTER TABLE "subscription" ADD CONSTRAINT "FK_567ea867f45fdcb0423f10849b3" FOREIGN KEY ("ownerId") REFERENCES "user"("id") ON DELETE CASCADE ON UPDATE NO ACTION`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ADD CONSTRAINT "FK_2b74e105b66d5b127356f86ea94" FOREIGN KEY ("subscriptionDataId") REFERENCES "subscription"("id") ON DELETE SET NULL ON UPDATE NO ACTION`,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "story" DROP CONSTRAINT "FK_07fb425a48f0c809bf2be4253a8"`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" DROP CONSTRAINT "FK_2b74e105b66d5b127356f86ea94"`,
    );
    await queryRunner.query(
      `ALTER TABLE "subscription" DROP CONSTRAINT "FK_567ea867f45fdcb0423f10849b3"`,
    );
    await queryRunner.query(
      `ALTER TABLE "userdata" DROP CONSTRAINT "FK_bf5a183f6cd897f24cd56345801"`,
    );
    await queryRunner.query(`DROP TABLE "user"`);
    await queryRunner.query(`DROP TABLE "subscription"`);
    await queryRunner.query(`DROP TABLE "userdata"`);
  }
}
