import { nanoid } from "nanoid";
import {
  BeforeInsert,
  BeforeUpdate,
  Column,
  Entity,
  PrimaryColumn,
} from "typeorm";

@Entity("token_metrics")
export class TokenMetrics {
  @PrimaryColumn()
  id: string;

  @Column({ type: "timestamp", default: () => "CURRENT_TIMESTAMP" })
  flushDate: Date;

  @Column({ type: "integer", default: 0 })
  tokenCount: number;

  @BeforeInsert()
  generateID() {
    this.id = nanoid();
  }

  @BeforeUpdate()
  updateTimestamp() {
    this.flushDate = new Date();
  }
}
