import { Module } from "@nestjs/common";
import { HttpModule } from "@nestjs/axios";
import { APP_GUARD } from "@nestjs/core";
import { TypeOrmModule } from "@nestjs/typeorm";
import { User } from "../user/user.entity";
import { UserBasedThrottlerGuard } from "../shared/guards/user-based-throttler.guard";
import { UserModule } from "../user/user.module";
import { AIModuleController } from "./ai-module.controller";
import { AiModule } from "./ai-module.entity";
import { AIModuleService } from "./ai-module.service";
import { AIController } from "./ai.controller";
import { AINodeGateway } from "./ai.gateway";
import { AIService } from "./ai.service";
import { createHydraService } from "./hydra.service";
import { TokenMetrics } from "./analytics/token-metrics.entity";
import { ThrottlerGuard } from "@nestjs/throttler";
import { StepCharge } from "./step-charge.entity";

@Module({
  imports: [
    UserModule,
    HttpModule,
    TypeOrmModule.forFeature([AiModule, User, TokenMetrics, StepCharge]),
  ],
  controllers: [AIController, AIModuleController],
  providers: [
    {
      provide: "GENERATION_SERVICE",
      useFactory: async () => {
        return await createHydraService();
      },
    },
    AIService,
    AIModuleService,
    AINodeGateway,
  ],
})
export class AIModule {}
