import { Injectable } from "@nestjs/common";
import {
  SubscribeMessage,
  WebSocketGateway,
  WebSocketServer,
} from "@nestjs/websockets";
import { Server } from "ws";
import { AIModuleService } from "./ai-module.service";
import { AIService } from "./ai.service";

@Injectable()
@WebSocketGateway({
  path: "/ai/internal/node-pipe",
})
export class AINodeGateway {
  constructor(
    private readonly aiService: AIService,
    private readonly aiModuleService: AIModuleService,
  ) {}

  @WebSocketServer()
  server: Server;

  @SubscribeMessage("token")
  onTokenEvent(_client: any, data: any) {
    if (data.uuid) this.aiService.onNewNodeData(data);
    return;
  }

  @SubscribeMessage("training_update")
  onTrainingEvent(_client: any, data: any) {
    if (data.id) this.aiModuleService.onTrainingUpdate(data);
  }
}
