import { customAlphabet } from "nanoid";
import { User } from "../user/user.entity";
import {
  BeforeInsert,
  BeforeUpdate,
  Column,
  CreateDateColumn,
  Entity,
  JoinColumn,
  ManyToOne,
  PrimaryColumn,
} from "typeorm";

const nanoid = customAlphabet(
  "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-",
  21,
);

@Entity("ai_training_module")
export class AiModule {
  @PrimaryColumn()
  id: string;

  @CreateDateColumn()
  createdAt: Date;

  @Column({ type: "timestamp", default: () => "CURRENT_TIMESTAMP" })
  lastUpdatedAt: Date;

  @BeforeInsert()
  generateID() {
    this.id = nanoid();
  }

  @BeforeUpdate()
  updateTimestamp() {
    this.lastUpdatedAt = new Date();
  }

  @Column({ default: "pending" })
  status: "pending" | "training" | "ready" | "error";

  @Column({
    type: "bytea",
    nullable: true,
  })
  data: Buffer;

  @Column({ type: "jsonb", default: [] })
  lossHistory: number[];

  @Column({ default: "", length: 64 })
  name: string;

  @Column({ default: "", length: 256 })
  description: string;

  @Column({ type: "float4", default: 1.0 })
  lr: number;

  @Column({ type: "integer", default: 1 })
  steps: number;

  @Column({ default: "", length: 64 })
  model: string;

  @ManyToOne(() => User, { onDelete: "CASCADE" })
  @JoinColumn()
  owner: User;

  @Column({ default: false })
  deleted: boolean;
}
