package gobot_http

import (
	"bytes"
	"encoding/json"
	"errors"
	"io"
	"log"
	"nai-gobot/includes"
	"net/http"
	"strings"
)

func GenerateImage(genReq includes.ImageGenerationRequest, api *includes.APIEndpoint, logRequests bool) (includes.ImageGeneration, error) {
	images := make([]string, 0)
	marshal, err := json.Marshal(genReq)
	if logRequests {
		log.Printf("Request: %v", string(marshal))
	}
	if err != nil {
		return includes.ImageGeneration{}, err
	}
	jsonBody := bytes.NewBuffer(marshal)
	resp, err := http.Post(api.URL+"/generate-stream", "application/json", jsonBody)
	if resp.StatusCode != http.StatusOK {
		return includes.ImageGeneration{}, errors.New("API returned non 200 status code, error: " + resp.Status)
	}
	if err != nil {
		return includes.ImageGeneration{}, err
	}
	body, err := io.ReadAll(resp.Body)
	if err != nil {
		return includes.ImageGeneration{}, errors.New("error reading response body, error: " + err.Error())
	}
	b64Images := strings.Split(string(body), "\n")
	if len(b64Images) < 3 {
		return includes.ImageGeneration{}, errors.New(b64Images[0])
	}
	for index := 2; index < len(b64Images)-2; index += 4 {
		images = append(images, b64Images[index][5:])
	}
	defer func(Body io.ReadCloser) {
		err := Body.Close()
		if err != nil {
			log.Printf("Error closing body: %v", err.Error())
		}
	}(resp.Body)

	return includes.ImageGeneration{
		Prompt: genReq.Prompt,
		Images: images[:genReq.NumGenerations],
	}, nil
}
