

import { readFileSync, writeFileSync } from "fs"
import {inspect} from "util"
import { addExtension, Unpackr } from "msgpackr"

import { Document } from "./document/document"
import { HistoryNode, HistoryRoot } from "./document/history"
import { SectionDiff, SectionDiffReplace, SectionDiffText } from "./document/section"


/**
 * Serialization
 */
 addExtension({
    Class: SectionDiffReplace,
    type: 42,
    write(instance: SectionDiffReplace) {
        return {
            from: instance.from,
            to: instance.to,
        }
    },
    read(data) {
        return Object.assign(new SectionDiffReplace(), data)
    },
})
addExtension({
    Class: SectionDiffText,
    type: 41,
    write(instance: SectionDiffText) {
        return {
            parts: instance.parts,
            metas: instance.metas,
        }
    },
    read(data) {
        return Object.assign(new SectionDiffText(), data)
    },
})
addExtension({
    Class: SectionDiff,
    type: 40,
    write(instance: SectionDiff) {
        return instance.diff
    },
    read(data) {
        return Object.assign(new SectionDiff(), { diff: data })
    },
})

/**
 * Serialization
 */
 addExtension({
    Class: HistoryNode,
    type: 31,
    write(instance: HistoryNode) {
        return {
            id: instance.id,
            parent: instance.parent,
            children: instance.children,
            route: instance.route,
            changes: instance.changes,
            date: instance.date,
        }
    },
    // unpack(buffer) {
    //     console.info("UNPAPACK " + inspect(buffer, {depth:null, colors:true, showHidden:true}))
    //     return Object.assign(new HistoryNode(), {...buffer})
    // },
    read(data) {
        console.info("NONONODE", data)
        return Object.assign(new HistoryNode(), data)
    },
})
addExtension({
    Class: HistoryRoot,
    type: 30,
    write(instance: HistoryRoot) {
        const json = instance.toJSON()
        return {
            root: json.root,
            current: json.current,
            nodes: json.nodes,
        }
    },
    read(data) {
        return Object.assign(new HistoryRoot(), data)
    },
})
/**
 * Serialization
 */
 addExtension({
    Class: Document,
    type: 20,
    write(instance: Document) {
        const json = instance.toJSON()
        return {
            sections: json.sections,
            order: json.order,
            history: json.history,
            dirtySections: json.dirtySections,
            step: json.step,
        }
    },
    read(data) {
        return Object.assign(new Document(), data)
    },
})


const deserializeDocument = (json?: string) => {
    if (!json) return
    const unpackr = new Unpackr({
        bundleStrings: true,
        moreTypes: true,
        structuredClone: false,
        useRecords: true,
    })
    writeFileSync("./data.bin", Buffer.from(json, 'base64'))
    try {
        return unpackr.unpack(Buffer.from(json, 'base64'))
    } catch (error) {
        console.error(error, true, 'failed deserializing document')
        throw error
    }
}

const doc = readFileSync("./data.txt", {encoding:"utf8"}).trim()
const des = deserializeDocument(doc)

console.info(inspect(des, {depth:null, colors:true, showHidden:true}))
