/* eslint-disable @next/next/no-img-element */

import { NextPage } from 'next'
import { Block, Column, Grid, MaskImage, MOBILE_LARGE, PrimaryContent, Row, SecondaryContent, Space, TABLET_SMALL } from '../components/common'
import { useRef } from 'react'
import styled from 'styled-components'
import Handshake from '../assets/icons/handshake.svg';
import ArrowRightSmall from '../assets/icons/arrow-right-small.svg';
import Link from 'next/link';
import { AltColorButtonLink } from '../components/button';

interface Opening {
    name: string,
    description: string,
    responsibilities: string,
    lookingFor: string,
    bonus: string[],
}

export const openings = new Map<string, Opening>([
    ['test1', {
        name: 'Test 1',
        description: 'Test description 1.',
        responsibilities: 'Test responsibilities.',
        lookingFor: 'Test looking for.',
        bonus: ['one', 'two', 'three'],
    }],
    ['test2', {
        name: 'Test 2',
        description: 'Test description 2.',
        responsibilities: 'Test responsibilities.',
        lookingFor: 'Test looking for.',
        bonus: ['one', 'two', 'three'],
    }],
    ['test3', {
        name: 'Test 3',
        description: 'Test description 3.',
        responsibilities: 'Test responsibilities.',
        lookingFor: 'Test looking for.',
        bonus: ['one', 'two', 'three'],
    }],
    ['test4', {
        name: 'Test 4',
        description: 'Test description 4.',
        responsibilities: 'Test responsibilities.',
        lookingFor: 'Test looking for.',
        bonus: ['one', 'two', 'three'],
    }],
    ['test5', {
        name: 'Test 6',
        description: 'Test description 5.',
        responsibilities: 'Test responsibilities.',
        lookingFor: 'Test looking for.',
        bonus: ['one', 'two', 'three'],
    }],
    ['test6', {
        name: 'Test 6',
        description: 'Test description 6.',
        responsibilities: 'Test responsibilities.',
        lookingFor: 'Test looking for.',
        bonus: ['one', 'two', 'three'],
    }],
])


const values = [
    {
        name: 'Explore and Experiment',
        description: 'Unless we’re pushing to get a certain feature done, feel free to try something new out! Every idea brought to the table is appreciated and discussed.'
    },
    {
        name: 'Work Stress-free',
        description: 'We’re here to push boundaries in the AI consumer world, but that doesn’t mean you can’t have a little fun along the way. Our entire team emerged from the internet, so we’re a long ways from professional.'
    },
    {
        name: 'Ask For Help',
        description: 'No one is all-knowing. Sometimes you might need a little push in the right direction to get something done. Never be afraid to reach out if it means getting your problem solved sooner rather than later.'
    },
    {
        name: 'Interact with the Community',
        description: 'Our community is what keeps us going, and we try to recognize that every single day. We hate companies that act higher than their community, so we try to change that by keeping in touch with ours through multiple mediums.'
    }
]

const ValuesContent = styled(Block)`
  background-color: #E4E4F5;
  border-bottom: 1px solid #1A1A1A;
  border-top: 1px solid #1A1A1A;
  padding-top: 80px !important;
  padding-bottom: 80px !important;
`

const OpeningsContent = styled(Block)`
  background-color: #E4E4F5;
  padding-top: 85px !important;
  padding-bottom: 100px !important;
`


const Jobs: NextPage = () => {
    const contentRef = useRef<HTMLDivElement>(null)

    return (
        <>
            <PrimaryContent>
                <div ref={contentRef} style={{
                    height: '100%',
                    display: 'flex',
                    flexDirection: 'column'
                }}>
                    <Column reverse>
                        <h1 className={'altFont altColor'} style={{ maxWidth: 560 }}>Come work with us.</h1>
                        <Space height={50} />
                        <h2 className={'altFont'}>Want to get in on the action?</h2>
                    </Column>
                    <Space height={20} />
                    <p style={{ fontSize: '18px', lineHeight: '24px' }}>We’re looking for some new talent to join our team! <br />
                        Our intention is to spark a growing ripple in the AI world, and we’d love for you to ride the waves with us.</p>
                    <Space height={50} />
                    <AltColorButtonLink style={{ width: 'max-content' }} href='#openings'> View Open Positions</AltColorButtonLink>
                </div>
                <Space height={60} />
            </PrimaryContent>
            <ValuesContent>
                <Row>
                    <MaskImage style={{ height: '33px', width: '33px' }} src={Handshake.src} color={'black'} />
                    <Space width={15} />
                    <div>
                        <h3 style={{ fontWeight: 700, fontSize: '22px' }}>Core Values</h3>
                        <div style={{ fontSize: '18px' }}>Beyond all else, members are encouraged to:</div>
                    </div>
                </Row>
                <Space height={40} />
                <Grid columns={2} gap={'30px 80px'} breakpoints={[{ width: TABLET_SMALL, columns: 1 }]}>
                    {values.map((value, i) => (
                        <Row key={i} style={{ alignItems: 'flex-start' }}>
                            <div className={'altFont'} style={{ fontSize: '40px', width: '58px', flex: '0 0 auto' }}>{i + 1}.</div>
                            <div>
                                <div className={'altFont altColor'} style={{ fontSize: '22px' }}>{value.name}</div>
                                <Space height={10} />
                                <p style={{ fontSize: '18px' }}>{value.description}</p>
                            </div>
                        </Row>
                    ))}
                </Grid>
            </ValuesContent>
            <OpeningsContent id='openings'>
                <h1 className={'altFont altColor'} style={{ maxWidth: 560 }}>Openings</h1>
                <Space height={40} />
                <Grid columns={3} gap={'50px 39px'} breakpoints={[{ width: TABLET_SMALL, columns: 2 }, { width: MOBILE_LARGE, columns: 1 }]}>
                    {[...openings.entries()].map(([id, opening], i) => (
                        <div key={i}>
                            <h2 style={{ fontWeight: 700 }}>{opening.name}</h2>
                            <Space height={20} />
                            <p style={{ fontSize: '18px' }}>{opening.description}</p>
                            <Space height={30} />
                            <Link href={`/jobs/${id}`}>
                                <a>
                                    <Row>
                                        <span className='bold altColor' style={{ fontSize: '18px' }}>Read More</span>
                                        <Space width={10} />
                                        <MaskImage style={{ height: 8, width: 5 }} src={ArrowRightSmall.src} color='#5200FF' />
                                    </Row>
                                </a>
                            </Link>
                        </div>
                    ))}
                </Grid>
            </OpeningsContent>
        </>
    )
}

export default Jobs
