/* eslint-disable @next/next/no-img-element */

import { NextPage } from 'next'
import styled from 'styled-components'
import { Column, Fill, Grid, MOBILE_LARGE, MOBILE_SMALL, PrimaryContent, Row, SecondaryContent, Space, TABLET_LARGE, TABLET_SMALL } from '../components/common'
import ProfileImage from '../assets/images/profile.webp'
import { StaticImageData } from 'next/image'
import { useRef } from 'react'
import Tabloid from '../assets/images/about/tabloid.webp'
import Kurumuz from '../assets/images/about/kurumuz.webp'
import Chris from '../assets/images/about/chris.jpg'
import Aini from '../assets/images/about/aini.webp'
import Goose1 from '../assets/images/geese/goose1.webp'
import Goose2 from '../assets/images/geese/goose2.webp'
import Goose3 from '../assets/images/geese/goose3.webp'
import Goose4 from '../assets/images/geese/goose4.webp'
import Goose5 from '../assets/images/geese/goose5.webp'


interface Person {
  name: string,
  position: string,
  desc: string,
  image: StaticImageData
}

const people = [
  {
    name: 'Kurumuz',
    position: 'CEO - Head of Research',
    desc: 'Rotates shapes.',
    image: Kurumuz
  },
  {
    name: 'Aini',
    position: 'Community Manager',
    desc: 'The voice behind official messaging. Community liaison and wearer of many hats. A German artist with a decade of experience in gaming, community management, translation, safety, and data analysis. Occasionally draws NovelAI\'s Art when not busy lurking for feedback.',
    image: Aini
  },
  {
    name: 'Chris',
    position: 'Frontend Developer - CTO',
    desc: 'Keeps things running all over the stack. Always obsessed with making sure everyone has a good experience. Game-developer and low-level programmer at heart.',
    image: Chris
  },
  {
    name: 'Aydan B',
    position: 'Designer',
    desc: 'Has been tackling design for 6+ years. Can also be caught dabbling in 3d modeling, music, game design, programming, video editing, and whatever else he can get his grubby little hands on.',
    image: Tabloid
  },
  {
    name: 'Aero',
    position: 'AI Developer',
    desc: 'Started coding in grade school, built a hugely popular world of warcraft addon which lead to a career in software. Also started getting in to machine learning in 2015 when char-rnn was making it\'s rounds, love researching cutting edge tech. Also tinkers with retro hardware on the side.',
    image: Goose3
  },
  {
    name: 'Occult Sage',
    position: 'Developer',
    desc: 'The old man in the crew, touches every bit of code, focuses on infrastructure, backend, and productizing the researchers\' work.',
    image: Goose2
  },
  {
    name: 'ght901',
    position: 'Frontend Developer',
    desc: '',
    image: Goose1
  },
  {
    name: 'Chims',
    position: 'Frontend Developer',
    desc: '',
    image: Goose4
  },
  {
    name: 'Mr. Accountant',
    position: 'Accountant',
    desc: '',
    image: Goose5
  },

]

const PeopleContent = styled(SecondaryContent)`
  padding-right: 0px;
  position: relative;
  @media (max-width: ${TABLET_LARGE}px) {
    padding:  60px 100px 80px;
  }
  @media (max-width: ${560}px) {
    padding: 50px 50px 50px 50px;
  }
  @media (max-width: ${MOBILE_SMALL}px) {
    padding: 50px 20px 50px 20px;
  }
`

const PeopleList = styled.div`
  position: absolute;
  max-height: calc(100% - 226px);
  width: 100%;
  left: 0;
  padding-left: 70px;
  padding-bottom: 40px;
  @media (max-width: ${TABLET_LARGE}px) {
    position: relative;
    max-height: 100%;
    padding: 0px;
  }
`

const About: NextPage = () => {
  const contentRef = useRef<HTMLDivElement>(null)

  return (
    <>
      <Grid columns={['5fr', '4fr']} breakpoints={[{ width: TABLET_LARGE, columns: 1, gap: 20 }]} style={{ minHeight: 'calc(100vh - 252px)' }}>
        <PrimaryContent style={{
          minHeight: '100vh'
        }}>
          <div ref={contentRef} style={{
            height: '100%',
            display: 'flex',
            flexDirection: 'column',
          }}>

            <Column reverse>
              <h1 className={'altFont altColor'} style={{ maxWidth: 560 }}>About Us.</h1>
              <Space height={50} />
              <h2 className={'altFont'}>What is there to even say?</h2>
            </Column>
            <Space height={20} />
            <p style={{ fontSize: '18px', lineHeight: '24px' }}>Follow the ripples of change in the world of artificial intelligence.</p>
            <Space height={50} />
            <p style={{ maxWidth: '649px' }}>
              Our mission: user-friendly, customizable AI experiences in line with your rights to privacy and transparency through AI research that brings about waves of change. Our unrestricted GPT powered sandboxes provide you the tools to unleash your creativity.
              <br />
              <br />
              Anlatan{"'"}s story begins in 2021, at the right moment in time for a ragtag band of personalities to come together and build something of our own - a service with unlimited freedom of expression and creativity without being dependent on any AI API providers.
              <br /> <br />
              United by AI passion, our small team consists of a broad age range working remotely from all over the globe. Every member brings a unique skill set to the table, bridging skills and supporting each other to create a tide of easily accessible, unconstrained AI products. </p>
          </div>
          <Space height={60} />
        </PrimaryContent>
        <PeopleContent>
          <h3>Our Team</h3>
          <Space height={10} />
          <PeopleList style={{ overflowY: 'auto' }}>

            <Space height={40} />
            <Grid columns={1} gap={40} breakpoints={[{ width: TABLET_LARGE, columns: 3, gap: 50 }, { width: TABLET_SMALL, columns: 2, gap: 50 }, { width: MOBILE_LARGE, columns: 1, gap: 40 }]}>
              {people.map((person, i) => (
                <div key={i} style={{ maxWidth: '441px' }}>
                  <Row style={{ alignItems: 'center' }}>
                    <img width={56} height={56} src={person.image.src} alt={person.name} style={{ borderRadius: '50%' }} />
                    <Space width={20} />
                    <Column>
                      <div className='bold' style={{ fontSize: '18px' }}>{person.name}</div>
                      <Space height={5} />
                      <div>{person.position}</div>
                    </Column>
                  </Row>
                  <Space height={25} />
                  <p>{person.desc}</p>
                </div>
              ))}
            </Grid>
          </PeopleList>
          <Fill />
        </PeopleContent>
      </Grid>
    </>
  )
}

export default About
