package web

import (
	"github.com/gin-gonic/gin"
	"log"
	"stability-image-api-middleware/config"
	"stability-image-api-middleware/web/common"
	"stability-image-api-middleware/web/routes"
)

func Serve() {
	if !config.Data.Debug {
		gin.SetMode(gin.ReleaseMode)
	}

	router := gin.Default()

	router.NoRoute(common.NoRouteHandler)

	routes.Register(router)

	if err := router.Run(config.Data.Web.ListenAddress); err != nil {
		log.Fatalln(err)
	}
}
