package db

import "stability-image-api-middleware/db/types"

func UserByToken(token string) (*types.User, error) {
	var users []*types.User

	db := DB.Limit(1).Where("token = ?", token).Find(&users)
	if db.Error != nil {
		return nil, db.Error
	}

	if len(users) == 0 {
		return nil, nil
	}

	return users[0], nil
}
