import styled from 'styled-components'
import Link from 'next/link'
import Head from 'next/head'
import { StaticImageData } from 'next/image'
import { FlexColSpacer, FlexRow } from '../styles/ui/layout'

import { ArrowLeftIcon } from '../styles/ui/icons'

import Krake from '../assets/kit/busts/krake.png'
import Sigurd from '../assets/kit/busts/sigurd.png'
import Euterpe from '../assets/kit/busts/euterpe.png'
import Genji from '../assets/kit/busts/genji.png'
import Snek from '../assets/kit/busts/snek.png'
import Calliope from '../assets/kit/busts/calliope.png'
import LogomarkLight from '../assets/kit/logomark/logomark_light.png'
import LogomarkLightSVG from '../assets/kit/logomark/logomark_light.svg'
import LogomarkDark from '../assets/kit/logomark/logomark_dark.png'
import LogomarkDarkSVG from '../assets/kit/logomark/logomark_dark.svg'
import LogomarkAlt from '../assets/kit/logomark/logomark_alt.png'
import LogomarkAltSVG from '../assets/kit/logomark/logomark_alt.svg'
import WordmarkLight from '../assets/kit/wordmark/wordmark_light.png'
import WordmarkLightSVG from '../assets/kit/wordmark/wordmark_light.svg'
import WordmarkDark from '../assets/kit/wordmark/wordmark_dark.png'
import WordmarkDarkSVG from '../assets/kit/wordmark/wordmark_dark.svg'
import WordmarkAlt from '../assets/kit/wordmark/wordmark_alt.png'
import WordmarkAltSVG from '../assets/kit/wordmark/wordmark_alt.svg'
import LogoLight from '../assets/kit/logo/logo_light.png'
import LogoLightSVG from '../assets/kit/logo/logo_light.svg'
import LogoDark from '../assets/kit/logo/logo_dark.png'
import LogoDarkSVG from '../assets/kit/logo/logo_dark.svg'
import LogoAlt from '../assets/kit/logo/logo_alt.png'
import LogoAltSVG from '../assets/kit/logo/logo_alt.svg'

import AssetsBackground from '../assets/images/backgrounds/asset_kit_background.svg'
import LightGrid from '../assets/images/backgrounds/checkerboard_light.svg'
import DarkGrid from '../assets/images/backgrounds/checkerboard_dark.svg'

import { LoginLink } from '.'

const VerticalBox = styled.div`
    display: flex;
    flex-direction: column;
    width: 100%;
    justify-content: center;
`
const Message = styled.h2`
    padding: 0;
    font-size: 2.125rem;
    line-height: 2rem;
    color: ${(props) => props.theme.colors.textMain};
`
const TagLine = styled.h2`
    font-size: 1.125rem;
    line-height: 2rem;
    color: ${(props) => props.theme.colors.textMain};
`

const OuterOuterContainer = styled.div`
    background-color: ${(props) => props.theme.colors.bg2};
    background-image: url(${AssetsBackground.src});
    background-size: 1600px auto;
    background-repeat: no-repeat;
    background-position: center top;
    display: flex;
`
const OuterContainer = styled(VerticalBox)`
    position: relative;
    overflow: auto;
    overflow: overlay;
    -moz-overflow: auto;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
`

const ToLanding = styled.div`
    font-size: 1rem;
    font-weight: 700;
    padding-left: 10px;
`

const CheckerBoard = styled.div<{ light?: boolean }>`
    height: 160px;
    background-image: url(${(props) => (props.light ? LightGrid.src : DarkGrid.src)});
    position: relative;
`

const Grid = styled.div<{ columns: number }>`
    display: grid;
    grid-template-columns: repeat(${(props) => props.columns}, 1fr);
    gap: 20px;
`

const WordmarkGrid = styled(Grid)`
    @media (max-width: 850px) {
        grid-template-columns: repeat(1, 1fr);
    }
`
const LogoGrid = styled(Grid)`
    @media (max-width: 500px) {
        grid-template-columns: repeat(1, 1fr);
    }
`
const ColorGrid = styled(Grid)`
    display: flex;
    flex-wrap: wrap;
`
const BustGrid = styled(Grid)`
    @media (max-width: 1100px) {
        grid-template-columns: repeat(3, 1fr);
    }

    @media (max-width: 600px) {
        grid-template-columns: repeat(2, 1fr);
    }
`

const DownloadImageLinks = styled.div<{ light?: boolean }>`
    display: flex;
    font-size: 0.875rem;
    position: absolute;
    right: 10px;
    bottom: 5px;
    a {
        color: ${(props) => (props.light ? props.theme.colors.bg2 : '#ffffff')};
        padding: 5px;
        opacity: 0.7;
        &:hover {
            opacity: 1;
            color: ${(props) => (props.light ? props.theme.colors.bg0 : props.theme.colors.textHeadings)};
        }
    }
`

const InnerContainer = styled.div`
    max-width: 1162px;
    width: 100%;
    flex: 0 0 auto;
    @media (max-width: 1300px) {
        padding: 0 30px;
    }
`

const Logomark = styled.div<{ logoURL: string }>`
    height: 100%;
    width: 100%;
    background-image: url(${(props) => props.logoURL});
    background-repeat: no-repeat;
    background-position: center;
`

const PressKitButton = styled.a`
    padding: 10px 30px;
    color: #000000;
    background-color: ${(props) => props.theme.colors.textHeadings};
    &:hover {
        background-color: ${(props) => props.theme.colors.textMain};
        color: #000000;
    }
`

const Banner = styled.div`
    height: 277px;
    background-color: ${(props) => props.theme.colors.bg2};
    border: 1px solid ${(props) => props.theme.colors.bg3};
    flex: 0 0 auto;
    width: 100%;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: space-around;
    > div {
        text-align: center;
    }
    p {
        max-width: 400px;
    }
`

const ModelBust = styled.div`
    background-color: ${(props) => props.theme.colors.bg1};
    margin: 5px;
    border: ${(props) => props.theme.colors.bg3} 1px solid;
    float: left;
    img {
        height: auto;
        width: 100%;
        max-height: 177px;
        max-width: 180px;
    }
    display: flex;
    > a {
        display: flex;
        align-items: center;
        width: 100%;
        display: flex;
        flex-direction: column;
    }
`

const ModelDesc = styled.div`
    border-top: 1px solid ${(props) => props.theme.colors.bg3};
    > :nth-child(1) {
        font-family: ${(props) => props.theme.fonts.headings};
    }
    display: flex;
    justify-content: space-between;
    width: 100%;
    padding: 13px 20px 15px 20px;
    font-weight: 600;
    align-items: baseline;
`

export default function Assets(): JSX.Element {
    return (
        <OuterOuterContainer>
            <Head>
                <title>Assets - NovelAI</title>
            </Head>
            <AssetContent />
        </OuterOuterContainer>
    )
}
function AssetContent(): JSX.Element {
    return (
        <OuterContainer>
            <InnerContainer>
                <FlexColSpacer min={23} max={23} />
                <FlexRow>
                    <Link href="/" passHref>
                        <a>
                            <FlexRow grow={false}>
                                <ArrowLeftIcon />
                                <ToLanding>Back to Landing</ToLanding>
                            </FlexRow>
                        </a>
                    </Link>
                    <FlexRow grow={false}>
                        <LoginLink target="_blank" href="https://blog.novelai.net/">
                            Blog
                        </LoginLink>
                        <LoginLink target="_blank" href="https://discord.com/invite/novelai">
                            Discord
                        </LoginLink>
                        <Link href="/login" passHref>
                            <LoginLink>Login</LoginLink>
                        </Link>
                    </FlexRow>
                </FlexRow>
                <FlexColSpacer min={30} max={30} />
            </InnerContainer>
            <Banner>
                <div>
                    <Message>Press Kit</Message>
                    <p>
                        Here you’ll find a complete download to all of our logos, site screenshots, and images
                    </p>
                    <FlexColSpacer min={20} max={20} />
                    <PressKitButton
                        href={
                            'https://github.com/NovelAI/novelai-assets/blob/master/Press%20Kit.zip?raw=true'
                        }
                        download
                    >
                        Download Press Kit
                    </PressKitButton>
                </div>
            </Banner>
            <InnerContainer>
                <FlexColSpacer min={40} max={40} />

                <Message>Branding</Message>
                <TagLine>Logomark</TagLine>
                <WordmarkGrid columns={3}>
                    <LogoBox
                        png={LogomarkLight}
                        svg={LogomarkLightSVG}
                        downloadName={'novelai_logomark_light'}
                    />
                    <LogoBox
                        png={LogomarkDark}
                        svg={LogomarkDarkSVG}
                        downloadName={'novelai_logomark_dark'}
                        light={true}
                    />
                    <LogoBox png={LogomarkAlt} svg={LogomarkAltSVG} downloadName={'novelai_logomark_alt'} />
                </WordmarkGrid>
                <FlexColSpacer min={30} max={30} />
                <TagLine>Wordmark</TagLine>
                <FlexColSpacer min={10} max={10} />
                <WordmarkGrid columns={3}>
                    <LogoBox
                        png={WordmarkLight}
                        svg={WordmarkLightSVG}
                        downloadName={'novelai_wordmark_light'}
                    />
                    <LogoBox
                        png={WordmarkDark}
                        svg={WordmarkDarkSVG}
                        downloadName={'novelai_wordmark_dark'}
                        light={true}
                    />
                    <LogoBox png={WordmarkAlt} svg={WordmarkAltSVG} downloadName={'novelai_wordmark_alt'} />
                </WordmarkGrid>
                <FlexColSpacer min={30} max={30} />
                <TagLine>Logo Glyph</TagLine>
                <FlexColSpacer min={10} max={10} />
                <LogoGrid columns={3}>
                    <LogoBox png={LogoLight} svg={LogoLightSVG} downloadName={'novelai_logo_light'} />
                    <LogoBox
                        png={LogoDark}
                        svg={LogoDarkSVG}
                        downloadName={'novelai_logo_dark'}
                        light={true}
                    />
                    <LogoBox png={LogoAlt} svg={LogoAltSVG} downloadName={'novelai_logo_alt'} />
                </LogoGrid>
                <FlexColSpacer min={30} max={30} />
                <TagLine>Main Colors</TagLine>
                <FlexColSpacer min={10} max={10} />
                <ColorGrid columns={5}>
                    <ColorBox colorName="Blonde" color="#F5F3C2"></ColorBox>
                    <ColorBox colorName="White" color="#F7F7F7"></ColorBox>
                    <ColorBox colorName="Pink" color="#EC56A7" light></ColorBox>
                    <ColorBox colorName="Green" color="#75CF67" light></ColorBox>
                    <ColorBox colorName="Purple" color="#9773FF" light></ColorBox>
                    <ColorBox colorName="Input Background" color="#0E0f21" light></ColorBox>
                    <ColorBox colorName="Dark Background" color="#13142C" light></ColorBox>
                    <ColorBox colorName="Background" color="#191B31" light border></ColorBox>
                    <ColorBox colorName="Foreground" color="#22253F" light></ColorBox>
                </ColorGrid>
                <FlexColSpacer min={30} max={30} />
                <TagLine>AI Model Busts</TagLine>
                <FlexColSpacer min={10} max={10} />
                <BustGrid columns={6}>
                    <ModelBox name="Krake" image={Krake} beaks="20b" />
                    <ModelBox name="Euterpe" image={Euterpe} beaks="13b" />
                    <ModelBox name="Sigurd" image={Sigurd} beaks="6b" />
                    <ModelBox name="Genji" image={Genji} beaks="6b" />
                    <ModelBox name="Snek" image={Snek} beaks="6b" />
                    <ModelBox name="Calliope" image={Calliope} beaks="2.7b" />
                </BustGrid>
                <FlexColSpacer min={320} max={320} />
            </InnerContainer>
        </OuterContainer>
    )
}

function LogoBox(props: {
    png: StaticImageData
    svg: StaticImageData
    downloadName: string
    light?: boolean
}): JSX.Element {
    return (
        <CheckerBoard light={props.light}>
            <Logomark logoURL={props.svg.src} />
            <DownloadImageLinks light={props.light}>
                <a href={props.png.src} download={props.downloadName}>
                    png
                </a>
                <a href={props.svg.src} download={props.downloadName}>
                    svg
                </a>
            </DownloadImageLinks>
        </CheckerBoard>
    )
}

const ColorContainer = styled.div<{ color: string; light?: boolean; border?: boolean }>`
    background-color: ${(props) => props.color};
    box-sizing: border-box;
    padding: 20px;
    height: 83px;
    color: ${(props) => (props.light ? '#fff' : '#000')};
    display: flex;
    flex-direction: column;
    align-items: flex-start;
    justify-content: center;
    font-size: 18px;
    font-weight: 700;
    ${(props) => props.border && `border: 1px solid ${props.theme.colors.bg3};`}
    min-width: 200px;
    flex: 1 1 0;
`

function ColorBox(props: {
    colorName: string
    color: string
    light?: boolean
    border?: boolean
}): JSX.Element {
    return (
        <ColorContainer color={props.color} light={props.light} border={props.border}>
            <div>{props.colorName}</div>
            <div>{props.color}</div>
        </ColorContainer>
    )
}

function ModelBox(props: { name: string; image: StaticImageData; beaks: string }): JSX.Element {
    return (
        <ModelBust>
            <a target="_blank" href={props.image.src} rel="noreferrer">
                <img src={props.image.src} alt="Snek" />
                <ModelDesc>
                    <div>{props.name}</div>
                    <div>{props.beaks}</div>
                </ModelDesc>
            </a>
        </ModelBust>
    )
}
