arpabet_to_ipa = {
    'AO': 'ɔ',
    'AO0': 'ɔ',
    'AO1': 'ɔ',
    'AO2': 'ɔ',
    'AA': 'ɑ',
    'AA0': 'ɑ',
    'AA1': 'ɑ',
    'AA2': 'ɑ',
    'IY': 'i',
    'IY0': 'i',
    'IY1': 'i',
    'IY2': 'i',
    'UW': 'u',
    'UW0': 'u',
    'UW1': 'u',
    'UW2': 'u',
    'EH': 'e',
    'EH0': 'e',
    'EH1': 'e',
    'EH2': 'e',
    'IH': 'ɪ',
    'IH0': 'ɪ',
    'IH1': 'ɪ',
    'IH2': 'ɪ',
    'UH': 'ʊ',
    'UH0': 'ʊ',
    'UH1': 'ʊ',
    'UH2': 'ʊ',
    'AH': 'ʌ',
    'AH0': 'ə',
    'AH1': 'ʌ',
    'AH2': 'ʌ',
    'AE': 'æ',
    'AE0': 'æ',
    'AE1': 'æ',
    'AE2': 'æ',
    'AX': 'ə',
    'AX0': 'ə',
    'AX1': 'ə',
    'AX2': 'ə',
    'EY': 'eɪ',
    'EY0': 'eɪ',
    'EY1': 'eɪ',
    'EY2': 'eɪ',
    'AY': 'aɪ',
    'AY0': 'aɪ',
    'AY1': 'aɪ',
    'AY2': 'aɪ',
    'OW': 'oʊ',
    'OW0': 'oʊ',
    'OW1': 'oʊ',
    'OW2': 'oʊ',
    'AW': 'aʊ',
    'AW0': 'aʊ',
    'AW1': 'aʊ',
    'AW2': 'aʊ',
    'OY': 'ɔɪ',
    'OY0': 'ɔɪ',
    'OY1': 'ɔɪ',
    'OY2': 'ɔɪ',
    'P': 'p',
    'B': 'b',
    'T': 't',
    'D': 'd',
    'K': 'k',
    'G': 'g',
    'CH': 'tʃ',
    'JH': 'dʒ',
    'F': 'f',
    'V': 'v',
    'TH': 'θ',
    'DH': 'ð',
    'S': 's',
    'Z': 'z',
    'SH': 'ʃ',
    'ZH': 'ʒ',
    'HH': 'h',
    'M': 'm',
    'N': 'n',
    'NG': 'ŋ',
    'L': 'l',
    'R': 'r',
    'ER': 'ɜr',
    'ER0': 'ɜr',
    'ER1': 'ɜr',
    'ER2': 'ɜr',
    'AXR': 'ər',
    'AXR0': 'ər',
    'AXR1': 'ər',
    'AXR2': 'ər',
    'W': 'w',
    'Y': 'j' 
}

thisdict = {}
for line in reversed((open('merged.dict.txt', "r").read()).splitlines()):
    thisdict[(line.split(" ",1))[0]] = (line.split(" ",1))[1].strip()

def IPA(text, punctuation=r"!?,.;", EOS_Token=False):
    out = ''
    for word_ in text.split(" "):
        word=word_; end_chars = ''
        while any(elem in word for elem in punctuation) and len(word) > 1:
            if word[-1] in punctuation: end_chars = word[-1] + end_chars; word = word[:-1]
            else: break
        try:
            word_arpa = thisdict[word.upper()]
            word = "".join([arpabet_to_ipa[x] for x in word_arpa.split(" ")])
            #word = "{" + str(word_arpa) + "}"
        except KeyError: pass
        out = (out + " " + word + end_chars).strip()
    if EOS_Token and out[-1] != ";": out += ";"
    return out

#print(IPA("This was a triumph."))
