﻿import { ScrollView } from 'react-native-gesture-handler'
import styled, { css } from 'styled-components/native'
import circles from '../../assets/images/backgrounds/circles.svg'
import { CrossIcon } from '../common/icons'
import { noBounceProps } from '../../styles/noBounce'

export const ModalView = styled.Pressable`
    background-color: rgba(0, 0, 0, 0.5);
    height: 100%;
    width: 100%;
    align-items: center;
    justify-content: center;
`

export const FullModalView = styled(ScrollView).attrs(() => ({
    ...{
        contentContainerStyle: {
            flexGrow: 1,
            flexDirection: 'column',
            justifyContent: 'space-between',
        },
        bounce: false,
        overScrollMode: 'never',
    },
    ...noBounceProps,
}))`
    background-color: ${(props) => props.theme.colors.bg2};
    padding-horizontal: 20px;
    width: 100%;
`

export const ModalBackgroundSplash = styled(circles).attrs((props) => ({
    height: '100%',
    width: '100%',
    primary: props.theme.colors.bg3,
}))`
    position: absolute;
    left: 0;
    z-index: -1;
    elevation: -1;
`

//pressable so parent component isn't triggered when pressed
export const InnerView = styled.Pressable`
    background-color: ${(props) => props.theme.colors.bg1};
    width: 84%;
    overflow: hidden;
`

export const TitleRow = styled.View<{ transparent: boolean }>`
    ${(props) =>
        props.transparent
            ? css``
            : css`
                  background-color: ${(props) => props.theme.colors.bg2};
                  border-color: ${(props) => props.theme.colors.bg3};
                  border-bottom-width: 1px;
              `}
    padding: 12px 0px 8px 20px;
    flex-direction: row;
    justify-content: space-between;
    width: 100%;
`

export const CloseButtonCross = styled(CrossIcon).attrs((props) => ({
    primary: props.theme.colors.textMain,
    height: 16,
    width: 16,
}))``

export const CloseButton = styled.TouchableOpacity`
    padding: 8px 20px 0;
`
