﻿import React from 'react'
import { useRecoilCallback, useRecoilState, useRecoilValue } from 'recoil'
import { getStorage } from '../../../shared/data/storage/storage'
import { StoryMetadata } from '../../../shared/data/story/storycontainer'
import { GlobalUserContext } from '../../../shared/globals/globals'
import { GenerationRequestActive, SelectedShelf, Session, StoryShelves } from '../../../shared/globals/state'
import { GoldenButtonText, RegularButton, RegularButtonText } from '../common/button.style'
import { ButtonsBlock as StyledButtonsBlock, Plus } from './menubar.style'

export default function ButtonsBlock(props: { addStoryPress: () => void }): JSX.Element {
    const session = useRecoilValue(Session)
    const [shelves, setShelves] = useRecoilState(StoryShelves)
    const selectedShelf = useRecoilValue(SelectedShelf)

    const addShelfPress = useRecoilCallback(({ snapshot, set }) => async () => {
        const generationRequestActive = await snapshot.getPromise(GenerationRequestActive)

        if (generationRequestActive) {
            return
        }

        const newShelf = new StoryMetadata()
        newShelf.title = 'New Shelf'
        GlobalUserContext.shelves.set(newShelf.id, newShelf)
        setShelves([...shelves, newShelf.id])
        getStorage(session).saveStoryShelf(newShelf)
        set(SelectedShelf, '')
    })

    return (
        <StyledButtonsBlock>
            <RegularButton onPress={props.addStoryPress} style={{ marginTop: 0, flex: 1, marginRight: 10 }}>
                <GoldenButtonText>
                    <Plus />
                    {'  '}New Story
                </GoldenButtonText>
            </RegularButton>
            <RegularButton
                onPress={addShelfPress}
                disabled={selectedShelf !== '' || session.noAccount}
                style={{ marginTop: 0, flex: 1, opacity: 0.5 }}
            >
                <RegularButtonText>New Shelf</RegularButtonText>
            </RegularButton>
        </StyledButtonsBlock>
    )
}
